/*
 * Decompiled with CFR 0.152.
 */
package nostr.api.factory;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import nostr.base.PublicKey;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;
import nostr.id.Identity;

public abstract class EventFactory<E extends GenericEvent, T extends BaseTag> {
    private final Identity identity;
    private final String content;
    private final List<T> tags;

    public EventFactory(Identity identity) {
        this(identity, new ArrayList(), "");
    }

    protected EventFactory() {
        this.identity = null;
        this.content = "";
        this.tags = new ArrayList<T>();
    }

    public EventFactory(Identity sender, String content) {
        this(sender, new ArrayList(), content);
    }

    public EventFactory(Identity sender, List<T> tags, String content) {
        this.content = content;
        this.tags = tags;
        this.identity = sender;
    }

    public abstract E create();

    protected void addTag(T tag) {
        this.tags.add(tag);
    }

    protected PublicKey getSender() {
        if (this.identity != null) {
            return this.identity.getPublicKey();
        }
        return null;
    }

    @Generated
    public Identity getIdentity() {
        return this.identity;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public List<T> getTags() {
        return this.tags;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventFactory)) {
            return false;
        }
        EventFactory other = (EventFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Identity this$identity = this.getIdentity();
        Identity other$identity = other.getIdentity();
        if (this$identity == null ? other$identity != null : !this$identity.equals(other$identity)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<T> this$tags = this.getTags();
        List<T> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventFactory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Identity $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : $identity.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<T> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EventFactory(identity=" + String.valueOf(this.getIdentity()) + ", content=" + this.getContent() + ", tags=" + String.valueOf(this.getTags()) + ")";
    }
}

