/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.util.List;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.NIP01;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.PublicKey;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;
import nostr.id.Identity;

public class NIP02
extends EventNostr {
    public NIP02(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.setSender(sender);
    }

    public NIP02 createContactListEvent(List<BaseTag> pubKeyTags) {
        GenericEvent genericEvent = new GenericEventFactory<BaseTag>(this.getSender(), 3, pubKeyTags, "").create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP02 addContactTag(@NonNull BaseTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (!tag.getCode().equals("p")) {
            throw new IllegalArgumentException("Tag must be a pubkey tag");
        }
        this.getEvent().addTag(tag);
        return this;
    }

    public NIP02 addContactTag(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return this.addContactTag(NIP01.createPubKeyTag(publicKey));
    }
}

