/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.PublicKey;
import nostr.encryption.MessageCipher04;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.GenericTag;
import nostr.event.tag.PubKeyTag;
import nostr.id.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIP04
extends EventNostr {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NIP04.class);

    public NIP04(@NonNull Identity sender, @NonNull PublicKey recipient) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        this.setSender(sender);
        this.setRecipient(recipient);
    }

    public NIP04 createDirectMessageEvent(@NonNull String content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        log.debug("Creating direct message event");
        String encryptedContent = NIP04.encrypt(this.getSender(), content, this.getRecipient());
        List<PubKeyTag> tags = List.of(new PubKeyTag(this.getRecipient()));
        GenericEvent genericEvent = new GenericEventFactory<PubKeyTag>(this.getSender(), 4, tags, encryptedContent).create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP04 encrypt() {
        NIP04.encryptDirectMessage(this.getSender(), this.getEvent());
        return this;
    }

    public static String encrypt(@NonNull Identity senderId, @NonNull String message, @NonNull PublicKey recipient) {
        if (senderId == null) {
            throw new NullPointerException("senderId is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        log.debug("Encrypting message from {} to {}", (Object)senderId.getPublicKey(), (Object)recipient);
        MessageCipher04 cipher = new MessageCipher04(senderId.getPrivateKey().getRawData(), recipient.getRawData());
        return cipher.encrypt(message);
    }

    public static String decrypt(@NonNull Identity identity, @NonNull String encryptedMessage, @NonNull PublicKey recipient) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (encryptedMessage == null) {
            throw new NullPointerException("encryptedMessage is marked non-null but is null");
        }
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        log.debug("Decrypting message for {}", (Object)identity.getPublicKey());
        MessageCipher04 cipher = new MessageCipher04(identity.getPrivateKey().getRawData(), recipient.getRawData());
        return cipher.decrypt(encryptedMessage);
    }

    private static void encryptDirectMessage(@NonNull Identity senderId, @NonNull GenericEvent directMessageEvent) {
        if (senderId == null) {
            throw new NullPointerException("senderId is marked non-null but is null");
        }
        if (directMessageEvent == null) {
            throw new NullPointerException("directMessageEvent is marked non-null but is null");
        }
        if (directMessageEvent.getKind() != 4) {
            throw new IllegalArgumentException("Event is not an encrypted direct message");
        }
        GenericTag recipient = directMessageEvent.getTags().stream().filter(t -> t.getCode().equalsIgnoreCase("p")).map(tag -> (GenericTag)tag).findFirst().orElseThrow(() -> new NoSuchElementException("No matching p-tag found."));
        PubKeyTag pubKeyTag = PubKeyTag.updateFields((GenericTag)recipient);
        PublicKey rcptPublicKey = pubKeyTag.getPublicKey();
        MessageCipher04 cipher = new MessageCipher04(senderId.getPrivateKey().getRawData(), rcptPublicKey.getRawData());
        String encryptedContent = cipher.encrypt(directMessageEvent.getContent());
        directMessageEvent.setContent(encryptedContent);
    }

    public static String decrypt(@NonNull Identity rcptId, @NonNull GenericEvent event) {
        if (rcptId == null) {
            throw new NullPointerException("rcptId is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (event.getKind() != 4) {
            throw new IllegalArgumentException("Event is not an encrypted direct message");
        }
        BaseTag recipient = event.getTags().stream().filter(t -> t.getCode().equalsIgnoreCase("p")).findFirst().orElseThrow(() -> new NoSuchElementException("No matching p-tag found."));
        PubKeyTag pTag = (PubKeyTag)recipient;
        boolean rcptFlag = NIP04.amITheRecipient(rcptId, event);
        if (!rcptFlag) {
            log.debug("Decrypting own sent message");
            MessageCipher04 cipher = new MessageCipher04(rcptId.getPrivateKey().getRawData(), pTag.getPublicKey().getRawData());
            return cipher.decrypt(event.getContent());
        }
        PublicKey sender = event.getPubKey();
        log.debug("Decrypting message from {}", (Object)sender);
        MessageCipher04 cipher = new MessageCipher04(rcptId.getPrivateKey().getRawData(), sender.getRawData());
        return cipher.decrypt(event.getContent());
    }

    private static boolean amITheRecipient(@NonNull Identity recipient, @NonNull GenericEvent event) {
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        BaseTag pTag = event.getTags().stream().filter(t -> t.getCode().equalsIgnoreCase("p")).findFirst().orElseThrow(() -> new NoSuchElementException("No matching p-tag found."));
        if (Objects.equals(recipient.getPublicKey(), ((PubKeyTag)pTag).getPublicKey())) {
            return true;
        }
        if (Objects.equals(recipient.getPublicKey(), event.getPubKey())) {
            return false;
        }
        throw new RuntimeException("Unrelated event");
    }
}

