/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.IEvent;
import nostr.event.entities.UserProfile;
import nostr.event.impl.GenericEvent;
import nostr.id.Identity;
import nostr.util.NostrUtil;
import nostr.util.validator.Nip05Validator;

public class NIP05
extends EventNostr {
    public NIP05(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.setSender(sender);
    }

    public NIP05 createInternetIdentifierMetadataEvent(@NonNull UserProfile profile) {
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        String content = this.getContent(profile);
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), 0, new ArrayList(), content).create();
        this.updateEvent(genericEvent);
        return this;
    }

    private String getContent(UserProfile profile) {
        try {
            String jsonString = IEvent.MAPPER_BLACKBIRD.writeValueAsString((Object)new Nip05Validator(profile.getNip05(), profile.getPublicKey().toString()));
            return NostrUtil.escapeJsonString((String)jsonString);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

