/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nostr.api.NostrIF;
import nostr.api.WebSocketClientHandler;
import nostr.api.service.NoteService;
import nostr.api.service.impl.DefaultNoteService;
import nostr.base.IEvent;
import nostr.base.ISignable;
import nostr.base.Signature;
import nostr.client.springwebsocket.SpringWebSocketClient;
import nostr.crypto.schnorr.Schnorr;
import nostr.event.BaseMessage;
import nostr.event.filter.Filters;
import nostr.event.impl.GenericEvent;
import nostr.event.message.ReqMessage;
import nostr.id.Identity;
import nostr.util.NostrUtil;

public class NostrSpringWebSocketClient
implements NostrIF {
    private final Map<String, WebSocketClientHandler> clientMap = new ConcurrentHashMap<String, WebSocketClientHandler>();
    private Identity sender;
    private NoteService noteService = new DefaultNoteService();
    private static volatile NostrSpringWebSocketClient INSTANCE;

    public NostrSpringWebSocketClient(String relayName, String relayUri) {
        this.setRelays(Map.of(relayName, relayUri));
    }

    public NostrSpringWebSocketClient(@NonNull NoteService noteService) {
        if (noteService == null) {
            throw new NullPointerException("noteService is marked non-null but is null");
        }
        this.noteService = noteService;
    }

    public NostrSpringWebSocketClient(@NonNull Identity sender, @NonNull NoteService noteService) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (noteService == null) {
            throw new NullPointerException("noteService is marked non-null but is null");
        }
        this.sender = sender;
        this.noteService = noteService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NostrIF getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<NostrSpringWebSocketClient> clazz = NostrSpringWebSocketClient.class;
        synchronized (NostrSpringWebSocketClient.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new NostrSpringWebSocketClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NostrIF getInstance(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (INSTANCE != null) return INSTANCE;
        Class<NostrSpringWebSocketClient> clazz = NostrSpringWebSocketClient.class;
        synchronized (NostrSpringWebSocketClient.class) {
            if (INSTANCE == null) {
                INSTANCE = new NostrSpringWebSocketClient(sender);
            } else {
                if (INSTANCE.getSender() != null) return INSTANCE;
                NostrSpringWebSocketClient.INSTANCE.sender = sender;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public NostrSpringWebSocketClient(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.sender = sender;
    }

    @Override
    public NostrIF setSender(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.sender = sender;
        return this;
    }

    @Override
    public NostrIF setRelays(@NonNull Map<String, String> relays) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        relays.entrySet().forEach(relayEntry -> {
            try {
                this.clientMap.putIfAbsent((String)relayEntry.getKey(), new WebSocketClientHandler((String)relayEntry.getKey(), (String)relayEntry.getValue()));
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Failed to initialize WebSocket client handler", e);
            }
        });
        return this;
    }

    @Override
    public List<String> sendEvent(@NonNull IEvent event) {
        GenericEvent genericEvent;
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (event instanceof GenericEvent && !this.verify(genericEvent = (GenericEvent)event)) {
            throw new IllegalStateException("Event verification failed");
        }
        return this.noteService.send(event, this.clientMap);
    }

    @Override
    public List<String> sendEvent(@NonNull IEvent event, Map<String, String> relays) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.setRelays(relays);
        return this.sendEvent(event);
    }

    @Override
    public List<String> sendRequest(@NonNull Filters filters, @NonNull String subscriptionId, Map<String, String> relays) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        return this.sendRequest(List.of(filters), subscriptionId, relays);
    }

    @Override
    public List<String> sendRequest(@NonNull List<Filters> filtersList, @NonNull String subscriptionId, Map<String, String> relays) {
        if (filtersList == null) {
            throw new NullPointerException("filtersList is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        this.setRelays(relays);
        return this.sendRequest(filtersList, subscriptionId);
    }

    @Override
    public List<String> sendRequest(@NonNull List<Filters> filtersList, @NonNull String subscriptionId) {
        if (filtersList == null) {
            throw new NullPointerException("filtersList is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        return filtersList.stream().map(filters -> this.sendRequest((Filters)filters, subscriptionId)).flatMap(Collection::stream).distinct().toList();
    }

    public static List<String> sendRequest(@NonNull SpringWebSocketClient client, @NonNull Filters filters, @NonNull String subscriptionId) throws IOException {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        return client.send((BaseMessage)new ReqMessage(subscriptionId, new Filters[]{filters}));
    }

    @Override
    public List<String> sendRequest(@NonNull Filters filters, @NonNull String subscriptionId) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        this.createRequestClient(subscriptionId);
        return this.clientMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith(":" + subscriptionId)).map(Map.Entry::getValue).map(webSocketClientHandler -> webSocketClientHandler.sendRequest(filters, webSocketClientHandler.getRelayName())).flatMap(Collection::stream).toList();
    }

    @Override
    public NostrIF sign(@NonNull Identity identity, @NonNull ISignable signable) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (signable == null) {
            throw new NullPointerException("signable is marked non-null but is null");
        }
        identity.sign(signable);
        return this;
    }

    @Override
    public boolean verify(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (!event.isSigned()) {
            throw new IllegalStateException("The event is not signed");
        }
        Signature signature = event.getSignature();
        try {
            byte[] message = NostrUtil.sha256((byte[])event.get_serializedEvent());
            return Schnorr.verify((byte[])message, (byte[])event.getPubKey().getRawData(), (byte[])signature.getRawData());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, String> getRelays() {
        return this.clientMap.values().stream().collect(Collectors.toMap(WebSocketClientHandler::getRelayName, WebSocketClientHandler::getRelayUri, (prev, next) -> next, HashMap::new));
    }

    @Override
    public void close() throws IOException {
        for (WebSocketClientHandler client : this.clientMap.values()) {
            client.close();
        }
    }

    protected WebSocketClientHandler newWebSocketClientHandler(String relayName, String relayUri) throws ExecutionException, InterruptedException {
        return new WebSocketClientHandler(relayName, relayUri);
    }

    private void createRequestClient(String subscriptionId) {
        this.clientMap.entrySet().stream().filter(entry -> !((String)entry.getKey()).contains(":")).forEach(entry -> {
            String requestKey = (String)entry.getKey() + ":" + subscriptionId;
            this.clientMap.computeIfAbsent(requestKey, key -> {
                try {
                    return this.newWebSocketClientHandler(requestKey, ((WebSocketClientHandler)entry.getValue()).getRelayUri());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException("Failed to create request client", e);
                }
            });
        });
    }

    @Generated
    public NostrSpringWebSocketClient() {
    }

    @Override
    @Generated
    public Identity getSender() {
        return this.sender;
    }
}

