/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.IEvent;
import nostr.client.springwebsocket.SpringWebSocketClient;
import nostr.client.springwebsocket.StandardWebSocketClient;
import nostr.client.springwebsocket.WebSocketClientIF;
import nostr.event.BaseMessage;
import nostr.event.filter.Filters;
import nostr.event.impl.GenericEvent;
import nostr.event.message.EventMessage;
import nostr.event.message.ReqMessage;

public class WebSocketClientHandler {
    private final SpringWebSocketClient eventClient;
    private final Map<String, SpringWebSocketClient> requestClientMap = new ConcurrentHashMap<String, SpringWebSocketClient>();
    private String relayName;
    private String relayUri;

    protected WebSocketClientHandler(@NonNull String relayName, @NonNull String relayUri) throws ExecutionException, InterruptedException {
        if (relayName == null) {
            throw new NullPointerException("relayName is marked non-null but is null");
        }
        if (relayUri == null) {
            throw new NullPointerException("relayUri is marked non-null but is null");
        }
        this.relayName = relayName;
        this.relayUri = relayUri;
        this.eventClient = new SpringWebSocketClient((WebSocketClientIF)new StandardWebSocketClient(relayUri), relayUri);
    }

    public List<String> sendEvent(@NonNull IEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        ((GenericEvent)event).validate();
        try {
            return this.eventClient.send((BaseMessage)new EventMessage(event)).stream().toList();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send event", e);
        }
    }

    protected List<String> sendRequest(@NonNull Filters filters, @NonNull String subscriptionId) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        try {
            SpringWebSocketClient client = this.requestClientMap.get(subscriptionId);
            if (client == null) {
                try {
                    this.requestClientMap.put(subscriptionId, new SpringWebSocketClient((WebSocketClientIF)new StandardWebSocketClient(this.relayUri), this.relayUri));
                    client = this.requestClientMap.get(subscriptionId);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException("Failed to initialize request client", e);
                }
            }
            return client.send((BaseMessage)new ReqMessage(subscriptionId, new Filters[]{filters}));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send request", e);
        }
    }

    public void close() throws IOException {
        this.eventClient.close();
        for (SpringWebSocketClient client : this.requestClientMap.values()) {
            client.close();
        }
    }

    @Generated
    public String getRelayName() {
        return this.relayName;
    }

    @Generated
    public String getRelayUri() {
        return this.relayUri;
    }
}

