/*
 * Decompiled with CFR 0.152.
 */
package nostr.api.factory.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import nostr.event.BaseTag;
import nostr.event.tag.GenericTag;

public class BaseTagFactory {
    private final String code;
    private final List<String> params;
    private String jsonString;

    protected BaseTagFactory() {
        this.code = "";
        this.params = new ArrayList<String>();
    }

    public BaseTagFactory(@NonNull String code, @NonNull List<String> params) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        this.code = code;
        this.params = params;
    }

    public BaseTagFactory(String code, String ... params) {
        this(code, Stream.of(params).filter(param -> param != null).toList());
    }

    public BaseTagFactory(@NonNull String jsonString) {
        if (jsonString == null) {
            throw new NullPointerException("jsonString is marked non-null but is null");
        }
        this.jsonString = jsonString;
        this.code = "";
        this.params = new ArrayList<String>();
    }

    public BaseTag create() {
        if (this.jsonString != null) {
            return (BaseTag)new ObjectMapper().readValue(this.jsonString, GenericTag.class);
        }
        return BaseTag.create((String)this.code, this.params);
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public List<String> getParams() {
        return this.params;
    }

    @Generated
    public String getJsonString() {
        return this.jsonString;
    }

    @Generated
    public void setJsonString(String jsonString) {
        this.jsonString = jsonString;
    }

    @Generated
    public String toString() {
        return "BaseTagFactory(code=" + this.getCode() + ", params=" + String.valueOf(this.getParams()) + ", jsonString=" + this.getJsonString() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseTagFactory)) {
            return false;
        }
        BaseTagFactory other = (BaseTagFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        List<String> this$params = this.getParams();
        List<String> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        String this$jsonString = this.getJsonString();
        String other$jsonString = other.getJsonString();
        return !(this$jsonString == null ? other$jsonString != null : !this$jsonString.equals(other$jsonString));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseTagFactory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        List<String> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        String $jsonString = this.getJsonString();
        result = result * 59 + ($jsonString == null ? 43 : $jsonString.hashCode());
        return result;
    }
}

