/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.util.List;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.NIP01;
import nostr.api.NIP12;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.event.entities.CustomerOrder;
import nostr.event.entities.PaymentRequest;
import nostr.event.entities.Product;
import nostr.event.entities.Stall;
import nostr.event.impl.GenericEvent;
import nostr.id.Identity;

public class NIP15
extends EventNostr {
    public NIP15(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.setSender(sender);
    }

    public NIP15 createMerchantRequestPaymentEvent(@NonNull PaymentRequest paymentRequest, @NonNull CustomerOrder customerOrder) {
        if (paymentRequest == null) {
            throw new NullPointerException("paymentRequest is marked non-null but is null");
        }
        if (customerOrder == null) {
            throw new NullPointerException("customerOrder is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), 4, paymentRequest.value()).create();
        genericEvent.addTag(NIP01.createPubKeyTag(customerOrder.getContact().getPublicKey()));
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP15 createCustomerOrderEvent(@NonNull CustomerOrder customerOrder) {
        if (customerOrder == null) {
            throw new NullPointerException("customerOrder is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), 4, customerOrder.value()).create();
        genericEvent.addTag(NIP01.createPubKeyTag(customerOrder.getContact().getPublicKey()));
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP15 createCreateOrUpdateStallEvent(@NonNull Stall stall) {
        if (stall == null) {
            throw new NullPointerException("stall is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), 30017, stall.value()).create();
        genericEvent.addTag(NIP01.createIdentifierTag(stall.getId()));
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP15 createCreateOrUpdateProductEvent(@NonNull Product product, List<String> categories) {
        if (product == null) {
            throw new NullPointerException("product is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), 30018, product.value()).create();
        genericEvent.addTag(NIP01.createIdentifierTag(product.getId()));
        if (categories != null && !categories.isEmpty()) {
            categories.forEach(category -> genericEvent.addTag(NIP12.createHashtagTag(category)));
        }
        this.updateEvent(genericEvent);
        return this;
    }
}

