/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.net.URL;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.factory.impl.BaseTagFactory;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;
import nostr.id.Identity;

public class NIP23
extends EventNostr {
    public NIP23(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.setSender(sender);
    }

    public NIP23 creatLongFormTextNoteEvent(@NonNull String content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), 30023, content).create();
        this.updateEvent(genericEvent);
        return this;
    }

    NIP23 createLongFormDraftEvent(@NonNull String content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), 30024, content).create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP23 addTitleTag(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.getEvent().addTag(NIP23.createTitleTag(title));
        return this;
    }

    public NIP23 addImageTag(@NonNull URL url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.getEvent().addTag(NIP23.createImageTag(url));
        return this;
    }

    public NIP23 addSummaryTag(@NonNull String summary) {
        if (summary == null) {
            throw new NullPointerException("summary is marked non-null but is null");
        }
        this.getEvent().addTag(NIP23.createSummaryTag(summary));
        return this;
    }

    public NIP23 addPublishedAtTag(@NonNull Long date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        this.getEvent().addTag(NIP23.createPublishedAtTag(date));
        return this;
    }

    public static BaseTag createTitleTag(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        return new BaseTagFactory("title", title).create();
    }

    public static BaseTag createImageTag(@NonNull URL url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return new BaseTagFactory("image", url.toString()).create();
    }

    public static BaseTag createImageTag(@NonNull URL url, String size) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return new BaseTagFactory("image", url.toString(), size).create();
    }

    public static BaseTag createSummaryTag(@NonNull String summary) {
        if (summary == null) {
            throw new NullPointerException("summary is marked non-null but is null");
        }
        return new BaseTagFactory("summary", summary).create();
    }

    public static BaseTag createPublishedAtTag(@NonNull Long date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return new BaseTagFactory("published_at", date.toString()).create();
    }
}

