/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.net.URI;
import java.net.URL;
import java.util.List;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.NIP01;
import nostr.api.NIP42;
import nostr.api.NIP60;
import nostr.api.factory.impl.BaseTagFactory;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.event.BaseTag;
import nostr.event.entities.Amount;
import nostr.event.entities.CashuMint;
import nostr.event.entities.CashuProof;
import nostr.event.entities.NutZap;
import nostr.event.entities.NutZapInformation;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.EventTag;
import nostr.id.Identity;

public class NIP61
extends EventNostr {
    public NIP61(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.setSender(sender);
    }

    public NIP61 createNutzapInformationalEvent(@NonNull NutZapInformation nutZapInformation) {
        if (nutZapInformation == null) {
            throw new NullPointerException("nutZapInformation is marked non-null but is null");
        }
        return this.createNutzapInformationalEvent(List.of(nutZapInformation.getP2pkPubkey()), nutZapInformation.getRelays(), nutZapInformation.getMints());
    }

    public NIP61 createNutzapInformationalEvent(@NonNull List<String> p2pkPubkey, @NonNull List<Relay> relays, @NonNull List<CashuMint> mints) {
        if (p2pkPubkey == null) {
            throw new NullPointerException("p2pkPubkey is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        if (mints == null) {
            throw new NullPointerException("mints is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), 10019).create();
        relays.forEach(relay -> genericEvent.addTag(NIP42.createRelayTag(relay)));
        mints.forEach(mint -> genericEvent.addTag(NIP60.createMintTag(mint)));
        p2pkPubkey.forEach(pubkey -> genericEvent.addTag(NIP61.createP2pkTag(pubkey)));
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP61 createNutzapEvent(@NonNull NutZap nutZap, @NonNull String content) {
        if (nutZap == null) {
            throw new NullPointerException("nutZap is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return this.createNutzapEvent(nutZap.getProofs(), URI.create(nutZap.getMint().getUrl()).toURL(), nutZap.getNutZappedEvent(), nutZap.getRecipient(), content);
    }

    public NIP61 createNutzapEvent(List<CashuProof> proofs, @NonNull URL url, EventTag nutzappedEventTag, @NonNull PublicKey recipient, @NonNull String content) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), 9321, content).create();
        proofs.forEach(proof -> genericEvent.addTag(NIP61.createProofTag(proof)));
        if (nutzappedEventTag != null) {
            genericEvent.addTag((BaseTag)nutzappedEventTag);
        }
        genericEvent.addTag(NIP61.createUrlTag(url.toString()));
        genericEvent.addTag(NIP01.createPubKeyTag(recipient));
        this.updateEvent(genericEvent);
        return this;
    }

    @Deprecated
    public NIP61 createNutzapEvent(@NonNull Amount amount, List<CashuProof> proofs, @NonNull URL url, List<EventTag> events, @NonNull PublicKey recipient, @NonNull String content) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), 9321, content).create();
        if (proofs != null) {
            proofs.forEach(proof -> genericEvent.addTag(NIP61.createProofTag(proof)));
        }
        if (events != null) {
            events.forEach(event -> genericEvent.addTag((BaseTag)event));
        }
        genericEvent.addTag(NIP61.createUrlTag(url.toString()));
        genericEvent.addTag(NIP60.createAmountTag(amount));
        genericEvent.addTag(NIP60.createUnitTag(amount.getUnit()));
        genericEvent.addTag(NIP01.createPubKeyTag(recipient));
        this.updateEvent(genericEvent);
        return this;
    }

    public static BaseTag createP2pkTag(@NonNull String pubkey) {
        if (pubkey == null) {
            throw new NullPointerException("pubkey is marked non-null but is null");
        }
        return new BaseTagFactory("pubkey", pubkey).create();
    }

    public static BaseTag createUrlTag(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return new BaseTagFactory("u", url).create();
    }

    public static BaseTag createProofTag(@NonNull CashuProof proof) {
        if (proof == null) {
            throw new NullPointerException("proof is marked non-null but is null");
        }
        return new BaseTagFactory("proof", proof.toString().replace("\"", "\\\"")).create();
    }
}

