/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.factory.impl.BaseTagFactory;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.IEvent;
import nostr.base.Marker;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.event.BaseTag;
import nostr.event.entities.UserProfile;
import nostr.event.filter.Filters;
import nostr.event.impl.GenericEvent;
import nostr.event.message.CloseMessage;
import nostr.event.message.EoseMessage;
import nostr.event.message.EventMessage;
import nostr.event.message.NoticeMessage;
import nostr.event.message.ReqMessage;
import nostr.event.tag.GenericTag;
import nostr.event.tag.IdentifierTag;
import nostr.event.tag.PubKeyTag;
import nostr.id.Identity;

public class NIP01
extends EventNostr {
    public NIP01(Identity sender) {
        this.setSender(sender);
    }

    public NIP01 createTextNoteEvent(String content) {
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), 1, content).create();
        this.updateEvent(genericEvent);
        return this;
    }

    @Deprecated
    public NIP01 createTextNoteEvent(Identity sender, String content) {
        GenericEvent genericEvent = new GenericEventFactory(sender, 1, content).create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP01 createTextNoteEvent(Identity sender, String content, List<PubKeyTag> recipients) {
        GenericEvent genericEvent = new GenericEventFactory<PubKeyTag>(sender, 1, recipients, content).create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP01 createTextNoteEvent(String content, List<PubKeyTag> recipients) {
        GenericEvent genericEvent = new GenericEventFactory<PubKeyTag>(this.getSender(), 1, recipients, content).create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP01 createTextNoteEvent(@NonNull List<BaseTag> tags, @NonNull String content) {
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory<BaseTag>(this.getSender(), 1, tags, content).create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP01 createMetadataEvent(@NonNull UserProfile profile) {
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        Identity sender = this.getSender();
        GenericEvent genericEvent = sender != null ? new GenericEventFactory(sender, 0, profile.toString()).create() : new GenericEventFactory(0, profile.toString()).create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP01 createReplaceableEvent(Integer kind, String content) {
        Identity sender = this.getSender();
        GenericEvent genericEvent = new GenericEventFactory(sender, kind, content).create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP01 createReplaceableEvent(List<BaseTag> tags, Integer kind, String content) {
        Identity sender = this.getSender();
        GenericEvent genericEvent = new GenericEventFactory<BaseTag>(sender, kind, tags, content).create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP01 createEphemeralEvent(List<BaseTag> tags, Integer kind, String content) {
        Identity sender = this.getSender();
        GenericEvent genericEvent = new GenericEventFactory<BaseTag>(sender, kind, tags, content).create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP01 createEphemeralEvent(Integer kind, String content) {
        Identity sender = this.getSender();
        GenericEvent genericEvent = new GenericEventFactory(sender, kind, content).create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP01 createAddressableEvent(Integer kind, String content) {
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), kind, content).create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP01 createAddressableEvent(@NonNull List<GenericTag> tags, @NonNull Integer kind, String content) {
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory<GenericTag>(this.getSender(), kind, tags, content).create();
        this.updateEvent(genericEvent);
        return this;
    }

    public static BaseTag createEventTag(@NonNull String relatedEventId) {
        if (relatedEventId == null) {
            throw new NullPointerException("relatedEventId is marked non-null but is null");
        }
        List<String> params = List.of(relatedEventId);
        return new BaseTagFactory("e", params).create();
    }

    public static BaseTag createEventTag(@NonNull String idEvent, String recommendedRelayUrl, Marker marker) {
        if (idEvent == null) {
            throw new NullPointerException("idEvent is marked non-null but is null");
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(idEvent);
        if (recommendedRelayUrl != null) {
            params.add(recommendedRelayUrl);
        }
        if (marker != null) {
            params.add(marker.getValue());
        }
        return new BaseTagFactory("e", params).create();
    }

    public static BaseTag createEventTag(@NonNull String idEvent, Marker marker) {
        if (idEvent == null) {
            throw new NullPointerException("idEvent is marked non-null but is null");
        }
        return NIP01.createEventTag(idEvent, (String)null, marker);
    }

    public static BaseTag createEventTag(@NonNull String idEvent, Relay recommendedRelay, Marker marker) {
        if (idEvent == null) {
            throw new NullPointerException("idEvent is marked non-null but is null");
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(idEvent);
        if (recommendedRelay != null) {
            params.add(recommendedRelay.getUri());
        }
        if (marker != null) {
            params.add(marker.getValue());
        }
        return new BaseTagFactory("e", params).create();
    }

    public static BaseTag createPubKeyTag(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(publicKey.toString());
        return new BaseTagFactory("p", params).create();
    }

    public static BaseTag createPubKeyTag(@NonNull PublicKey publicKey, String mainRelayUrl, String petName) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(publicKey.toString());
        params.add(mainRelayUrl);
        params.add(petName);
        return new BaseTagFactory("p", params).create();
    }

    public static BaseTag createPubKeyTag(@NonNull PublicKey publicKey, String mainRelayUrl) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(publicKey.toString());
        params.add(mainRelayUrl);
        return new BaseTagFactory("p", params).create();
    }

    public static BaseTag createIdentifierTag(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(id);
        return new BaseTagFactory("d", params).create();
    }

    public static BaseTag createAddressTag(@NonNull Integer kind, @NonNull PublicKey publicKey, BaseTag idTag, Relay relay) {
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        if (idTag != null && !idTag.getCode().equals("d")) {
            throw new IllegalArgumentException("idTag must be an identifier tag");
        }
        ArrayList<String> params = new ArrayList<String>();
        String param = kind + ":" + String.valueOf(publicKey) + ":";
        if (idTag != null) {
            if (idTag instanceof IdentifierTag) {
                param = param + ((IdentifierTag)idTag).getUuid();
            } else {
                throw new IllegalArgumentException("idTag must be an identifier tag");
            }
        }
        params.add(param);
        if (relay != null) {
            params.add(relay.getUri());
        }
        return new BaseTagFactory("a", params).create();
    }

    public static BaseTag createAddressTag(@NonNull Integer kind, @NonNull PublicKey publicKey, String id, Relay relay) {
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return NIP01.createAddressTag(kind, publicKey, NIP01.createIdentifierTag(id), relay);
    }

    public static BaseTag createAddressTag(@NonNull Integer kind, @NonNull PublicKey publicKey, String id) {
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return NIP01.createAddressTag(kind, publicKey, NIP01.createIdentifierTag(id), null);
    }

    public static EventMessage createEventMessage(@NonNull GenericEvent event, String subscriptionId) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return Optional.ofNullable(subscriptionId).map(subId -> new EventMessage((IEvent)event, subId)).orElse(new EventMessage((IEvent)event));
    }

    public static ReqMessage createReqMessage(@NonNull String subscriptionId, @NonNull List<Filters> filtersList) {
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        if (filtersList == null) {
            throw new NullPointerException("filtersList is marked non-null but is null");
        }
        return new ReqMessage(subscriptionId, filtersList);
    }

    public static CloseMessage createCloseMessage(@NonNull String subscriptionId) {
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        return new CloseMessage(subscriptionId);
    }

    public static EoseMessage createEoseMessage(@NonNull String subscriptionId) {
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        return new EoseMessage(subscriptionId);
    }

    public static NoticeMessage createNoticeMessage(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return new NoticeMessage(message);
    }
}

