/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.NIP01;
import nostr.api.factory.impl.BaseTagFactory;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.IEvent;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.event.BaseTag;
import nostr.event.entities.ZapRequest;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.EventTag;
import nostr.event.tag.GenericTag;
import nostr.event.tag.RelaysTag;
import nostr.id.Identity;
import org.apache.commons.text.StringEscapeUtils;

public class NIP57
extends EventNostr {
    public NIP57(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.setSender(sender);
    }

    public NIP57 createZapRequestEvent(@NonNull ZapRequest zapRequest, @NonNull String content, PublicKey recipientPubKey, GenericEvent zappedEvent, BaseTag addressTag) {
        if (zapRequest == null) {
            throw new NullPointerException("zapRequest is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), 9734, content).create();
        genericEvent.addTag((BaseTag)zapRequest.getRelaysTag());
        genericEvent.addTag(NIP57.createAmountTag(zapRequest.getAmount()));
        genericEvent.addTag(NIP57.createLnurlTag(zapRequest.getLnUrl()));
        if (recipientPubKey != null) {
            genericEvent.addTag(NIP01.createPubKeyTag(recipientPubKey));
        }
        if (zappedEvent != null) {
            genericEvent.addTag(NIP01.createEventTag(zappedEvent.getId()));
        }
        if (addressTag != null) {
            if (!"a".equals(addressTag.getCode())) {
                throw new IllegalArgumentException("tag must be of type AddressTag");
            }
            genericEvent.addTag(addressTag);
        }
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP57 createZapRequestEvent(@NonNull Long amount, @NonNull String lnUrl, @NonNull BaseTag relaysTags, @NonNull String content, PublicKey recipientPubKey, GenericEvent zappedEvent, BaseTag addressTag) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (lnUrl == null) {
            throw new NullPointerException("lnUrl is marked non-null but is null");
        }
        if (relaysTags == null) {
            throw new NullPointerException("relaysTags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (!relaysTags.getCode().equals("relays")) {
            throw new IllegalArgumentException("tag must be of type RelaysTag");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), 9734, content).create();
        genericEvent.addTag(relaysTags);
        genericEvent.addTag(NIP57.createAmountTag(amount));
        genericEvent.addTag(NIP57.createLnurlTag(lnUrl));
        if (recipientPubKey != null) {
            genericEvent.addTag(NIP01.createPubKeyTag(recipientPubKey));
        }
        if (zappedEvent != null) {
            genericEvent.addTag(NIP01.createEventTag(zappedEvent.getId()));
        }
        if (addressTag != null) {
            if (!addressTag.getCode().equals("a")) {
                throw new IllegalArgumentException("Address tag must be of type AddressTag");
            }
            genericEvent.addTag(addressTag);
        }
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP57 createZapRequestEvent(@NonNull Long amount, @NonNull String lnUrl, @NonNull List<Relay> relays, @NonNull String content, PublicKey recipientPubKey, GenericEvent zappedEvent, BaseTag addressTag) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (lnUrl == null) {
            throw new NullPointerException("lnUrl is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return this.createZapRequestEvent(amount, lnUrl, (BaseTag)new RelaysTag(relays), content, recipientPubKey, zappedEvent, addressTag);
    }

    public NIP57 createZapRequestEvent(@NonNull Long amount, @NonNull String lnUrl, @NonNull List<String> relays, @NonNull String content, PublicKey recipientPubKey) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (lnUrl == null) {
            throw new NullPointerException("lnUrl is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return this.createZapRequestEvent(amount, lnUrl, relays.stream().map(Relay::new).toList(), content, recipientPubKey, null, null);
    }

    public NIP57 createZapReceiptEvent(@NonNull GenericEvent zapRequestEvent, @NonNull String bolt11, @NonNull String preimage, @NonNull PublicKey zapRecipient) {
        if (zapRequestEvent == null) {
            throw new NullPointerException("zapRequestEvent is marked non-null but is null");
        }
        if (bolt11 == null) {
            throw new NullPointerException("bolt11 is marked non-null but is null");
        }
        if (preimage == null) {
            throw new NullPointerException("preimage is marked non-null but is null");
        }
        if (zapRecipient == null) {
            throw new NullPointerException("zapRecipient is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), 9735, "").create();
        genericEvent.addTag(NIP01.createPubKeyTag(zapRecipient));
        String descriptionSha256 = IEvent.MAPPER_BLACKBIRD.writeValueAsString((Object)zapRequestEvent);
        genericEvent.addTag(NIP57.createDescriptionTag(StringEscapeUtils.escapeJson((String)descriptionSha256)));
        genericEvent.addTag(NIP57.createBolt11Tag(bolt11));
        genericEvent.addTag(NIP57.createPreImageTag(preimage));
        genericEvent.addTag(NIP57.createZapSenderPubKeyTag(zapRequestEvent.getPubKey()));
        genericEvent.addTag(NIP01.createEventTag(zapRequestEvent.getId()));
        GenericTag addressTag = zapRequestEvent.getTags().stream().filter(tag -> tag.getCode().equals("a")).findFirst().orElse(null);
        if (addressTag != null) {
            genericEvent.addTag((BaseTag)addressTag);
        }
        genericEvent.setCreatedAt(zapRequestEvent.getCreatedAt());
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP57 addLnurlTag(@NonNull String lnurl) {
        if (lnurl == null) {
            throw new NullPointerException("lnurl is marked non-null but is null");
        }
        this.getEvent().addTag(NIP57.createLnurlTag(lnurl));
        return this;
    }

    public NIP57 addEventTag(@NonNull EventTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.getEvent().addTag((BaseTag)tag);
        return this;
    }

    public NIP57 addBolt11Tag(@NonNull String bolt11) {
        if (bolt11 == null) {
            throw new NullPointerException("bolt11 is marked non-null but is null");
        }
        this.getEvent().addTag(NIP57.createBolt11Tag(bolt11));
        return this;
    }

    public NIP57 addPreImageTag(@NonNull String preimage) {
        if (preimage == null) {
            throw new NullPointerException("preimage is marked non-null but is null");
        }
        this.getEvent().addTag(NIP57.createPreImageTag(preimage));
        return this;
    }

    public NIP57 addDescriptionTag(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.getEvent().addTag(NIP57.createDescriptionTag(description));
        return this;
    }

    public NIP57 addAmountTag(@NonNull Integer amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.getEvent().addTag(NIP57.createAmountTag(amount));
        return this;
    }

    public NIP57 addRecipientTag(@NonNull PublicKey recipient) {
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        this.getEvent().addTag(NIP01.createPubKeyTag(recipient));
        return this;
    }

    public NIP57 addZapTag(@NonNull PublicKey receiver, @NonNull List<Relay> relays, Integer weight) {
        if (receiver == null) {
            throw new NullPointerException("receiver is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        this.getEvent().addTag(NIP57.createZapTag(receiver, relays, weight));
        return this;
    }

    public NIP57 addZapTag(@NonNull PublicKey receiver, @NonNull List<Relay> relays) {
        if (receiver == null) {
            throw new NullPointerException("receiver is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        this.getEvent().addTag(NIP57.createZapTag(receiver, relays));
        return this;
    }

    public NIP57 addRelaysTag(@NonNull RelaysTag relaysTag) {
        if (relaysTag == null) {
            throw new NullPointerException("relaysTag is marked non-null but is null");
        }
        this.getEvent().addTag((BaseTag)relaysTag);
        return this;
    }

    public NIP57 addRelaysList(@NonNull List<Relay> relays) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        return this.addRelaysTag(new RelaysTag(relays));
    }

    public NIP57 addRelays(@NonNull List<String> relays) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        return this.addRelaysList(relays.stream().map(Relay::new).toList());
    }

    public NIP57 addRelays(String ... relays) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        return this.addRelays(List.of(relays));
    }

    public static BaseTag createLnurlTag(@NonNull String lnurl) {
        if (lnurl == null) {
            throw new NullPointerException("lnurl is marked non-null but is null");
        }
        return new BaseTagFactory("lnurl", lnurl).create();
    }

    public static BaseTag createBolt11Tag(@NonNull String bolt11) {
        if (bolt11 == null) {
            throw new NullPointerException("bolt11 is marked non-null but is null");
        }
        return new BaseTagFactory("bolt11", bolt11).create();
    }

    public static BaseTag createPreImageTag(@NonNull String preimage) {
        if (preimage == null) {
            throw new NullPointerException("preimage is marked non-null but is null");
        }
        return new BaseTagFactory("preimage", preimage).create();
    }

    public static BaseTag createDescriptionTag(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        return new BaseTagFactory("description", description).create();
    }

    public static BaseTag createAmountTag(@NonNull Number amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        return new BaseTagFactory("amount", amount.toString()).create();
    }

    public static BaseTag createZapSenderPubKeyTag(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return new BaseTagFactory("P", publicKey.toString()).create();
    }

    public static BaseTag createZapTag(@NonNull PublicKey receiver, @NonNull List<Relay> relays, Integer weight) {
        if (receiver == null) {
            throw new NullPointerException("receiver is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(receiver.toString());
        relays.stream().map(Relay::getUri).forEach(params::add);
        if (weight != null) {
            params.add(weight.toString());
        }
        return BaseTag.create((String)"zap", params);
    }

    public static BaseTag createZapTag(@NonNull PublicKey receiver, @NonNull List<Relay> relays) {
        if (receiver == null) {
            throw new NullPointerException("receiver is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        return NIP57.createZapTag(receiver, relays, null);
    }
}

