/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.IEvent;
import nostr.client.springwebsocket.SpringWebSocketClient;
import nostr.client.springwebsocket.StandardWebSocketClient;
import nostr.client.springwebsocket.WebSocketClientIF;
import nostr.event.BaseMessage;
import nostr.event.filter.Filters;
import nostr.event.impl.GenericEvent;
import nostr.event.message.CloseMessage;
import nostr.event.message.EventMessage;
import nostr.event.message.ReqMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketClientHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebSocketClientHandler.class);
    private final SpringWebSocketClient eventClient;
    private final Map<String, SpringWebSocketClient> requestClientMap = new ConcurrentHashMap<String, SpringWebSocketClient>();
    private final Function<String, SpringWebSocketClient> requestClientFactory;
    private final String relayName;
    private final String relayUri;

    protected WebSocketClientHandler(@NonNull String relayName, @NonNull String relayUri) throws ExecutionException, InterruptedException {
        if (relayName == null) {
            throw new NullPointerException("relayName is marked non-null but is null");
        }
        if (relayUri == null) {
            throw new NullPointerException("relayUri is marked non-null but is null");
        }
        this.relayName = relayName;
        this.relayUri = relayUri;
        this.eventClient = new SpringWebSocketClient((WebSocketClientIF)new StandardWebSocketClient(relayUri), relayUri);
        this.requestClientFactory = key -> this.createStandardRequestClient();
    }

    WebSocketClientHandler(@NonNull String relayName, @NonNull String relayUri, @NonNull SpringWebSocketClient eventClient, Map<String, SpringWebSocketClient> requestClients, Function<String, SpringWebSocketClient> requestClientFactory) {
        if (relayName == null) {
            throw new NullPointerException("relayName is marked non-null but is null");
        }
        if (relayUri == null) {
            throw new NullPointerException("relayUri is marked non-null but is null");
        }
        if (eventClient == null) {
            throw new NullPointerException("eventClient is marked non-null but is null");
        }
        this.relayName = relayName;
        this.relayUri = relayUri;
        this.eventClient = eventClient;
        Function<String, SpringWebSocketClient> function = this.requestClientFactory = requestClientFactory != null ? requestClientFactory : key -> this.createStandardRequestClient();
        if (requestClients != null) {
            this.requestClientMap.putAll(requestClients);
        }
    }

    public List<String> sendEvent(@NonNull IEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        ((GenericEvent)event).validate();
        try {
            return this.eventClient.send((BaseMessage)new EventMessage(event)).stream().toList();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send event", e);
        }
    }

    protected List<String> sendRequest(@NonNull Filters filters, @NonNull String subscriptionId) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        try {
            SpringWebSocketClient client = this.getOrCreateRequestClient(subscriptionId);
            return client.send((BaseMessage)new ReqMessage(subscriptionId, new Filters[]{filters}));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to send request", e);
        }
    }

    public AutoCloseable subscribe(@NonNull Filters filters, @NonNull String subscriptionId, @NonNull Consumer<String> listener, Consumer<Throwable> errorListener) {
        AutoCloseable delegate;
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        SpringWebSocketClient client = this.getOrCreateRequestClient(subscriptionId);
        Consumer<Throwable> safeError = errorListener != null ? errorListener : throwable -> log.warn("Subscription error on relay {} for {}", new Object[]{this.relayName, subscriptionId, throwable});
        try {
            delegate = client.subscribe((BaseMessage)new ReqMessage(subscriptionId, new Filters[]{filters}), listener, safeError, () -> safeError.accept(new IOException("Subscription closed by relay %s for id %s".formatted(this.relayName, subscriptionId))));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to establish subscription", e);
        }
        return () -> {
            Exception nonIoFailure;
            IOException ioFailure;
            block27: {
                block26: {
                    ioFailure = null;
                    nonIoFailure = null;
                    AutoCloseable closeFrameHandle = null;
                    try {
                        closeFrameHandle = client.subscribe((BaseMessage)new CloseMessage(subscriptionId), message -> {}, safeError, null);
                    }
                    catch (IOException e) {
                        safeError.accept(e);
                        ioFailure = e;
                    }
                    finally {
                        block25: {
                            if (closeFrameHandle != null) {
                                try {
                                    closeFrameHandle.close();
                                }
                                catch (IOException e) {
                                    safeError.accept(e);
                                    if (ioFailure == null) {
                                        ioFailure = e;
                                    }
                                }
                                catch (Exception e) {
                                    safeError.accept(e);
                                    if (nonIoFailure != null) break block25;
                                    nonIoFailure = e;
                                }
                            }
                        }
                    }
                    try {
                        delegate.close();
                    }
                    catch (IOException e) {
                        safeError.accept(e);
                        if (ioFailure == null) {
                            ioFailure = e;
                        }
                    }
                    catch (Exception e) {
                        safeError.accept(e);
                        if (nonIoFailure != null) break block26;
                        nonIoFailure = e;
                    }
                }
                this.requestClientMap.remove(subscriptionId);
                try {
                    client.close();
                }
                catch (IOException e) {
                    safeError.accept(e);
                    if (ioFailure != null) break block27;
                    ioFailure = e;
                }
            }
            if (ioFailure != null) {
                throw ioFailure;
            }
            if (nonIoFailure != null) {
                throw new IOException("Failed to close subscription cleanly", nonIoFailure);
            }
        };
    }

    public void close() throws IOException {
        this.eventClient.close();
        for (SpringWebSocketClient client : this.requestClientMap.values()) {
            client.close();
        }
    }

    protected SpringWebSocketClient getOrCreateRequestClient(String subscriptionId) {
        try {
            return this.requestClientMap.computeIfAbsent(subscriptionId, this.requestClientFactory);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw e;
        }
    }

    private SpringWebSocketClient createStandardRequestClient() {
        try {
            return new SpringWebSocketClient((WebSocketClientIF)new StandardWebSocketClient(this.relayUri), this.relayUri);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to initialize request client", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while initializing request client", e);
        }
    }

    @Generated
    public String getRelayName() {
        return this.relayName;
    }

    @Generated
    public String getRelayUri() {
        return this.relayUri;
    }
}

