/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import nostr.api.NostrSpringWebSocketClient;
import nostr.base.IEvent;
import nostr.base.ISignable;
import nostr.base.PublicKey;
import nostr.event.BaseMessage;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;
import nostr.event.json.codec.BaseMessageDecoder;
import nostr.id.Identity;
import org.apache.commons.lang3.stream.Streams;

public abstract class EventNostr
extends NostrSpringWebSocketClient {
    private GenericEvent event;
    private PublicKey recipient;

    public EventNostr(@NonNull Identity sender) {
        super(sender);
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
    }

    public EventNostr sign() {
        super.sign(this.getSender(), (ISignable)this.event);
        return this;
    }

    public <U extends BaseMessage> U send() {
        return this.send(this.getRelays());
    }

    public <U extends BaseMessage> U send(Map<String, String> relays) {
        List<String> messages = super.sendEvent((IEvent)this.event, relays);
        BaseMessageDecoder decoder = new BaseMessageDecoder();
        return (U)((BaseMessage)new Streams.FailableStream(messages.stream()).map(msg -> decoder.decode(msg)).filter(Objects::nonNull).stream().findFirst().orElseThrow(() -> new RuntimeException("No message received")));
    }

    public <U extends BaseMessage> U signAndSend() {
        return this.signAndSend(this.getRelays());
    }

    public <U extends BaseMessage> U signAndSend(Map<String, String> relays) {
        return this.sign().send(relays);
    }

    @Override
    public EventNostr setSender(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        super.setSender(sender);
        return this;
    }

    @Override
    public EventNostr setRelays(@NonNull Map<String, String> relays) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        super.setRelays(relays);
        return this;
    }

    public EventNostr setRecipient(@NonNull PublicKey recipient) {
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        this.recipient = recipient;
        return this;
    }

    public void updateEvent(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.setEvent(event);
        this.event.update();
    }

    public EventNostr addTag(@NonNull BaseTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.getEvent().addTag(tag);
        return this;
    }

    @Generated
    public GenericEvent getEvent() {
        return this.event;
    }

    @Generated
    public PublicKey getRecipient() {
        return this.recipient;
    }

    @Generated
    public EventNostr() {
    }

    @Generated
    public void setEvent(GenericEvent event) {
        this.event = event;
    }
}

