/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.nip01.NIP01EventBuilder;
import nostr.api.nip01.NIP01MessageFactory;
import nostr.api.nip01.NIP01TagFactory;
import nostr.base.Marker;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.event.BaseTag;
import nostr.event.entities.UserProfile;
import nostr.event.filter.Filters;
import nostr.event.impl.GenericEvent;
import nostr.event.message.CloseMessage;
import nostr.event.message.EoseMessage;
import nostr.event.message.EventMessage;
import nostr.event.message.NoticeMessage;
import nostr.event.message.ReqMessage;
import nostr.event.tag.GenericTag;
import nostr.event.tag.PubKeyTag;
import nostr.id.Identity;

public class NIP01
extends EventNostr {
    private final NIP01EventBuilder eventBuilder;

    public NIP01(Identity sender) {
        super(sender);
        this.eventBuilder = new NIP01EventBuilder(sender);
    }

    @Override
    public NIP01 setSender(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        super.setSender(sender);
        this.eventBuilder.updateDefaultSender(sender);
        return this;
    }

    public NIP01 createTextNoteEvent(String content) {
        this.updateEvent(this.eventBuilder.buildTextNote(content));
        return this;
    }

    public NIP01 createTextNoteEvent(String content, List<PubKeyTag> recipients) {
        this.updateEvent(this.eventBuilder.buildRecipientTextNote(content, recipients));
        return this;
    }

    public NIP01 createTextNoteEvent(@NonNull List<BaseTag> tags, @NonNull String content) {
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.updateEvent(this.eventBuilder.buildTaggedTextNote(tags, content));
        return this;
    }

    public NIP01 createMetadataEvent(@NonNull UserProfile profile) {
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        GenericEvent genericEvent = Optional.ofNullable(this.getSender()).map(identity -> this.eventBuilder.buildMetadataEvent((Identity)identity, profile.toString())).orElse(this.eventBuilder.buildMetadataEvent(profile.toString()));
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP01 createReplaceableEvent(Integer kind, String content) {
        this.updateEvent(this.eventBuilder.buildReplaceableEvent(kind, content));
        return this;
    }

    public NIP01 createReplaceableEvent(List<BaseTag> tags, Integer kind, String content) {
        this.updateEvent(this.eventBuilder.buildReplaceableEvent(tags, kind, content));
        return this;
    }

    public NIP01 createEphemeralEvent(List<BaseTag> tags, Integer kind, String content) {
        this.updateEvent(this.eventBuilder.buildEphemeralEvent(tags, kind, content));
        return this;
    }

    public NIP01 createEphemeralEvent(Integer kind, String content) {
        this.updateEvent(this.eventBuilder.buildEphemeralEvent(kind, content));
        return this;
    }

    public NIP01 createAddressableEvent(Integer kind, String content) {
        this.updateEvent(this.eventBuilder.buildAddressableEvent(kind, content));
        return this;
    }

    public NIP01 createAddressableEvent(@NonNull List<GenericTag> tags, @NonNull Integer kind, String content) {
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        this.updateEvent(this.eventBuilder.buildAddressableEvent(tags, kind, content));
        return this;
    }

    public static BaseTag createEventTag(@NonNull String relatedEventId) {
        if (relatedEventId == null) {
            throw new NullPointerException("relatedEventId is marked non-null but is null");
        }
        return NIP01TagFactory.eventTag(relatedEventId);
    }

    public static BaseTag createEventTag(@NonNull String idEvent, String recommendedRelayUrl, Marker marker) {
        if (idEvent == null) {
            throw new NullPointerException("idEvent is marked non-null but is null");
        }
        return NIP01TagFactory.eventTag(idEvent, recommendedRelayUrl, marker);
    }

    public static BaseTag createEventTag(@NonNull String idEvent, Marker marker) {
        if (idEvent == null) {
            throw new NullPointerException("idEvent is marked non-null but is null");
        }
        return NIP01TagFactory.eventTag(idEvent, marker);
    }

    public static BaseTag createEventTag(@NonNull String idEvent, Relay recommendedRelay, Marker marker) {
        if (idEvent == null) {
            throw new NullPointerException("idEvent is marked non-null but is null");
        }
        return NIP01TagFactory.eventTag(idEvent, recommendedRelay, marker);
    }

    public static BaseTag createPubKeyTag(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return NIP01TagFactory.pubKeyTag(publicKey);
    }

    public static BaseTag createPubKeyTag(@NonNull PublicKey publicKey, String mainRelayUrl, String petName) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return NIP01TagFactory.pubKeyTag(publicKey, mainRelayUrl, petName);
    }

    public static BaseTag createPubKeyTag(@NonNull PublicKey publicKey, String mainRelayUrl) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return NIP01TagFactory.pubKeyTag(publicKey, mainRelayUrl);
    }

    public static BaseTag createIdentifierTag(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return NIP01TagFactory.identifierTag(id);
    }

    public static BaseTag createAddressTag(@NonNull Integer kind, @NonNull PublicKey publicKey, BaseTag idTag, Relay relay) {
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return NIP01TagFactory.addressTag(kind, publicKey, idTag, relay);
    }

    public static BaseTag createAddressTag(@NonNull Integer kind, @NonNull PublicKey publicKey, String id, Relay relay) {
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return NIP01TagFactory.addressTag(kind, publicKey, id, relay);
    }

    public static BaseTag createAddressTag(@NonNull Integer kind, @NonNull PublicKey publicKey, String id) {
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return NIP01TagFactory.addressTag(kind, publicKey, id);
    }

    public static EventMessage createEventMessage(@NonNull GenericEvent event, String subscriptionId) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return NIP01MessageFactory.eventMessage(event, subscriptionId);
    }

    public static ReqMessage createReqMessage(@NonNull String subscriptionId, @NonNull List<Filters> filtersList) {
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        if (filtersList == null) {
            throw new NullPointerException("filtersList is marked non-null but is null");
        }
        return NIP01MessageFactory.reqMessage(subscriptionId, filtersList);
    }

    public static CloseMessage createCloseMessage(@NonNull String subscriptionId) {
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        return NIP01MessageFactory.closeMessage(subscriptionId);
    }

    public static EoseMessage createEoseMessage(@NonNull String subscriptionId) {
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        return NIP01MessageFactory.eoseMessage(subscriptionId);
    }

    public static NoticeMessage createNoticeMessage(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return NIP01MessageFactory.noticeMessage(message);
    }
}

