/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.Kind;
import nostr.base.json.EventJsonMapper;
import nostr.event.entities.UserProfile;
import nostr.event.impl.GenericEvent;
import nostr.event.json.codec.EventEncodingException;
import nostr.id.Identity;
import nostr.util.NostrUtil;
import nostr.util.validator.Nip05Validator;

public class NIP05
extends EventNostr {
    public NIP05(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.setSender(sender);
    }

    public NIP05 createInternetIdentifierMetadataEvent(@NonNull UserProfile profile) {
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        String content = this.getContent(profile);
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), Kind.SET_METADATA.getValue(), new ArrayList(), content).create();
        this.updateEvent(genericEvent);
        return this;
    }

    private String getContent(UserProfile profile) {
        try {
            String jsonString = EventJsonMapper.mapper().writeValueAsString((Object)Nip05Validator.builder().nip05(profile.getNip05()).publicKey(profile.getPublicKey().toString()).build());
            return NostrUtil.escapeJsonString((String)jsonString);
        }
        catch (JsonProcessingException ex) {
            throw new EventEncodingException("Failed to encode NIP-05 profile content", (Throwable)ex);
        }
    }
}

