/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.NIP01;
import nostr.api.NIP44;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.json.EventJsonMapper;
import nostr.event.impl.GenericEvent;
import nostr.id.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NIP46
extends EventNostr {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NIP46.class);

    public NIP46(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.setSender(sender);
    }

    public NIP46 createRequestEvent(@NonNull Request request, @NonNull PublicKey signer) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (signer == null) {
            throw new NullPointerException("signer is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), Kind.NOSTR_CONNECT.getValue(), NIP44.encrypt(this.getSender(), request.toString(), signer)).create();
        genericEvent.addTag(NIP01.createPubKeyTag(signer));
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP46 createResponseEvent(@NonNull Response response, @NonNull PublicKey app) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (app == null) {
            throw new NullPointerException("app is marked non-null but is null");
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), Kind.NOSTR_CONNECT.getValue(), NIP44.encrypt(this.getSender(), response.toString(), app)).create();
        genericEvent.addTag(NIP01.createPubKeyTag(app));
        this.updateEvent(genericEvent);
        return this;
    }

    public static final class Request
    implements Serializable {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(Request.class);
        private String id;
        private String method;
        private final Set<String> params = new LinkedHashSet<String>();

        public Request(String id, String method, Set<String> params) {
            this.id = id;
            this.method = method;
            if (params != null) {
                this.params.addAll(params);
            }
        }

        public void addParam(String param) {
            this.params.add(param);
        }

        @JsonIgnore
        public int getParamCount() {
            return this.params.size();
        }

        @JsonIgnore
        public boolean containsParam(String param) {
            return this.params.contains(param);
        }

        public String toString() {
            try {
                return EventJsonMapper.mapper().writeValueAsString((Object)this);
            }
            catch (JsonProcessingException ex) {
                log.warn("Error converting request to JSON: {}", (Object)ex.getMessage());
                return "{}";
            }
        }

        public static Request fromString(@NonNull String jsonString) {
            if (jsonString == null) {
                throw new NullPointerException("jsonString is marked non-null but is null");
            }
            try {
                return (Request)EventJsonMapper.mapper().readValue(jsonString, Request.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getMethod() {
            return this.method;
        }

        @Generated
        public Set<String> getParams() {
            return this.params;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setMethod(String method) {
            this.method = method;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            Set<String> this$params = this.getParams();
            Set<String> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            Set<String> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }

        @Generated
        public Request(String id, String method) {
            this.id = id;
            this.method = method;
        }

        @Generated
        public Request() {
        }
    }

    public static final class Response
    implements Serializable {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(Response.class);
        private String id;
        private String error;
        private String result;

        public String toString() {
            try {
                return EventJsonMapper.mapper().writeValueAsString((Object)this);
            }
            catch (JsonProcessingException ex) {
                log.warn("Error converting response to JSON: {}", (Object)ex.getMessage());
                return "{}";
            }
        }

        public static Response fromString(@NonNull String jsonString) {
            if (jsonString == null) {
                throw new NullPointerException("jsonString is marked non-null but is null");
            }
            try {
                return (Response)EventJsonMapper.mapper().readValue(jsonString, Response.class);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getError() {
            return this.error;
        }

        @Generated
        public String getResult() {
            return this.result;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setError(String error) {
            this.error = error;
        }

        @Generated
        public void setResult(String result) {
            this.result = result;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$error = this.getError();
            String other$error = other.getError();
            if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                return false;
            }
            String this$result = this.getResult();
            String other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            String $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        @Generated
        public Response(String id, String error, String result) {
            this.id = id;
            this.error = error;
            this.result = result;
        }

        @Generated
        public Response() {
        }
    }
}

