/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.util.List;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.nip01.NIP01TagFactory;
import nostr.api.nip57.NIP57TagFactory;
import nostr.api.nip57.NIP57ZapReceiptBuilder;
import nostr.api.nip57.NIP57ZapRequestBuilder;
import nostr.api.nip57.ZapRequestParameters;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.event.BaseTag;
import nostr.event.entities.ZapRequest;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.EventTag;
import nostr.event.tag.RelaysTag;
import nostr.id.Identity;

public class NIP57
extends EventNostr {
    private final NIP57ZapRequestBuilder zapRequestBuilder;
    private final NIP57ZapReceiptBuilder zapReceiptBuilder;

    public NIP57(@NonNull Identity sender) {
        super(sender);
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.zapRequestBuilder = new NIP57ZapRequestBuilder(sender);
        this.zapReceiptBuilder = new NIP57ZapReceiptBuilder(sender);
    }

    @Override
    public NIP57 setSender(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        super.setSender(sender);
        this.zapRequestBuilder.updateDefaultSender(sender);
        this.zapReceiptBuilder.updateDefaultSender(sender);
        return this;
    }

    public NIP57 createZapRequestEvent(@NonNull ZapRequest zapRequest, @NonNull String content, PublicKey recipientPubKey, GenericEvent zappedEvent, BaseTag addressTag) {
        if (zapRequest == null) {
            throw new NullPointerException("zapRequest is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.updateEvent(this.zapRequestBuilder.buildFromZapRequest(this.resolveSender(), zapRequest, content, recipientPubKey, zappedEvent, addressTag));
        return this;
    }

    public NIP57 createZapRequestEvent(@NonNull ZapRequestParameters parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.updateEvent(this.zapRequestBuilder.build(parameters));
        return this;
    }

    public NIP57 createZapRequestEvent(@NonNull Long amount, @NonNull String lnUrl, @NonNull BaseTag relaysTags, @NonNull String content, PublicKey recipientPubKey, GenericEvent zappedEvent, BaseTag addressTag) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (lnUrl == null) {
            throw new NullPointerException("lnUrl is marked non-null but is null");
        }
        if (relaysTags == null) {
            throw new NullPointerException("relaysTags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return this.createZapRequestEvent(ZapRequestParameters.builder().amount(amount).lnUrl(lnUrl).relaysTag(this.requireRelaysTag(relaysTags)).content(content).recipientPubKey(recipientPubKey).zappedEvent(zappedEvent).addressTag(addressTag).build());
    }

    public NIP57 createZapRequestEvent(@NonNull Long amount, @NonNull String lnUrl, @NonNull List<Relay> relays, @NonNull String content, PublicKey recipientPubKey, GenericEvent zappedEvent, BaseTag addressTag) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (lnUrl == null) {
            throw new NullPointerException("lnUrl is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return this.createZapRequestEvent(ZapRequestParameters.builder().amount(amount).lnUrl(lnUrl).relays(relays).content(content).recipientPubKey(recipientPubKey).zappedEvent(zappedEvent).addressTag(addressTag).build());
    }

    public NIP57 createZapRequestEvent(@NonNull Long amount, @NonNull String lnUrl, @NonNull List<String> relays, @NonNull String content, PublicKey recipientPubKey) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (lnUrl == null) {
            throw new NullPointerException("lnUrl is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return this.createZapRequestEvent(ZapRequestParameters.builder().amount(amount).lnUrl(lnUrl).relays(relays.stream().map(Relay::new).toList()).content(content).recipientPubKey(recipientPubKey).build());
    }

    public NIP57 createZapReceiptEvent(@NonNull GenericEvent zapRequestEvent, @NonNull String bolt11, @NonNull String preimage, @NonNull PublicKey zapRecipient) {
        if (zapRequestEvent == null) {
            throw new NullPointerException("zapRequestEvent is marked non-null but is null");
        }
        if (bolt11 == null) {
            throw new NullPointerException("bolt11 is marked non-null but is null");
        }
        if (preimage == null) {
            throw new NullPointerException("preimage is marked non-null but is null");
        }
        if (zapRecipient == null) {
            throw new NullPointerException("zapRecipient is marked non-null but is null");
        }
        this.updateEvent(this.zapReceiptBuilder.build(zapRequestEvent, bolt11, preimage, zapRecipient));
        return this;
    }

    public NIP57 addLnurlTag(@NonNull String lnurl) {
        if (lnurl == null) {
            throw new NullPointerException("lnurl is marked non-null but is null");
        }
        this.getEvent().addTag(NIP57TagFactory.lnurl(lnurl));
        return this;
    }

    public NIP57 addEventTag(@NonNull EventTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.getEvent().addTag((BaseTag)tag);
        return this;
    }

    public NIP57 addBolt11Tag(@NonNull String bolt11) {
        if (bolt11 == null) {
            throw new NullPointerException("bolt11 is marked non-null but is null");
        }
        this.getEvent().addTag(NIP57TagFactory.bolt11(bolt11));
        return this;
    }

    public NIP57 addPreImageTag(@NonNull String preimage) {
        if (preimage == null) {
            throw new NullPointerException("preimage is marked non-null but is null");
        }
        this.getEvent().addTag(NIP57TagFactory.preimage(preimage));
        return this;
    }

    public NIP57 addDescriptionTag(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.getEvent().addTag(NIP57TagFactory.description(description));
        return this;
    }

    public NIP57 addAmountTag(@NonNull Integer amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.getEvent().addTag(NIP57TagFactory.amount(amount));
        return this;
    }

    public NIP57 addRecipientTag(@NonNull PublicKey recipient) {
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        this.getEvent().addTag(NIP01TagFactory.pubKeyTag(recipient));
        return this;
    }

    public NIP57 addZapTag(@NonNull PublicKey receiver, @NonNull List<Relay> relays, Integer weight) {
        if (receiver == null) {
            throw new NullPointerException("receiver is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        this.getEvent().addTag(NIP57TagFactory.zap(receiver, relays, weight));
        return this;
    }

    public NIP57 addZapTag(@NonNull PublicKey receiver, @NonNull List<Relay> relays) {
        if (receiver == null) {
            throw new NullPointerException("receiver is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        this.getEvent().addTag(NIP57TagFactory.zap(receiver, relays));
        return this;
    }

    public NIP57 addRelaysTag(@NonNull RelaysTag relaysTag) {
        if (relaysTag == null) {
            throw new NullPointerException("relaysTag is marked non-null but is null");
        }
        this.getEvent().addTag((BaseTag)relaysTag);
        return this;
    }

    public NIP57 addRelaysList(@NonNull List<Relay> relays) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        return this.addRelaysTag(new RelaysTag(relays));
    }

    public NIP57 addRelays(@NonNull List<String> relays) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        return this.addRelaysList(relays.stream().map(Relay::new).toList());
    }

    public NIP57 addRelays(String ... relays) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        return this.addRelays(List.of(relays));
    }

    public static BaseTag createLnurlTag(@NonNull String lnurl) {
        if (lnurl == null) {
            throw new NullPointerException("lnurl is marked non-null but is null");
        }
        return NIP57TagFactory.lnurl(lnurl);
    }

    public static BaseTag createBolt11Tag(@NonNull String bolt11) {
        if (bolt11 == null) {
            throw new NullPointerException("bolt11 is marked non-null but is null");
        }
        return NIP57TagFactory.bolt11(bolt11);
    }

    public static BaseTag createPreImageTag(@NonNull String preimage) {
        if (preimage == null) {
            throw new NullPointerException("preimage is marked non-null but is null");
        }
        return NIP57TagFactory.preimage(preimage);
    }

    public static BaseTag createDescriptionTag(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        return NIP57TagFactory.description(description);
    }

    public static BaseTag createAmountTag(@NonNull Number amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        return NIP57TagFactory.amount(amount);
    }

    public static BaseTag createZapSenderPubKeyTag(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return NIP57TagFactory.zapSender(publicKey);
    }

    public static BaseTag createZapTag(@NonNull PublicKey receiver, @NonNull List<Relay> relays, Integer weight) {
        if (receiver == null) {
            throw new NullPointerException("receiver is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        return NIP57TagFactory.zap(receiver, relays, weight);
    }

    public static BaseTag createZapTag(@NonNull PublicKey receiver, @NonNull List<Relay> relays) {
        if (receiver == null) {
            throw new NullPointerException("receiver is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        return NIP57TagFactory.zap(receiver, relays);
    }

    private RelaysTag requireRelaysTag(BaseTag tag) {
        if (tag instanceof RelaysTag) {
            RelaysTag relaysTag = (RelaysTag)tag;
            return relaysTag;
        }
        throw new IllegalArgumentException("tag must be of type RelaysTag");
    }

    private Identity resolveSender() {
        Identity sender = this.getSender();
        if (sender == null) {
            throw new IllegalStateException("Sender identity is required for zap operations");
        }
        return sender;
    }
}

