/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.NIP01;
import nostr.api.NIP42;
import nostr.api.NIP44;
import nostr.api.NIP57;
import nostr.api.factory.impl.BaseTagFactory;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.Kind;
import nostr.base.json.EventJsonMapper;
import nostr.event.BaseTag;
import nostr.event.entities.Amount;
import nostr.event.entities.CashuMint;
import nostr.event.entities.CashuQuote;
import nostr.event.entities.CashuToken;
import nostr.event.entities.CashuWallet;
import nostr.event.entities.SpendingHistory;
import nostr.event.impl.GenericEvent;
import nostr.event.json.codec.BaseTagEncoder;
import nostr.event.json.codec.EventEncodingException;
import nostr.id.Identity;

public class NIP60
extends EventNostr {
    public NIP60(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.setSender(sender);
    }

    public NIP60 createWalletEvent(@NonNull CashuWallet wallet) {
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        GenericEvent walletEvent = new GenericEventFactory<BaseTag>(this.getSender(), Kind.WALLET.getValue(), this.getWalletEventTags(wallet), this.getWalletEventContent(wallet)).create();
        this.updateEvent(walletEvent);
        return this;
    }

    public NIP60 createTokenEvent(@NonNull CashuToken token, @NonNull CashuWallet wallet) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        GenericEvent tokenEvent = new GenericEventFactory<BaseTag>(this.getSender(), Kind.WALLET_UNSPENT_PROOF.getValue(), this.getTokenEventTags(wallet), this.getTokenEventContent(token)).create();
        this.updateEvent(tokenEvent);
        return this;
    }

    public NIP60 createSpendingHistoryEvent(@NonNull SpendingHistory spendingHistory, @NonNull CashuWallet wallet) {
        if (spendingHistory == null) {
            throw new NullPointerException("spendingHistory is marked non-null but is null");
        }
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        GenericEvent spendingHistoryEvent = new GenericEventFactory<BaseTag>(this.getSender(), Kind.WALLET_TX_HISTORY.getValue(), this.getSpendingHistoryEventTags(wallet), this.getSpendingHistoryEventContent(spendingHistory)).create();
        this.updateEvent(spendingHistoryEvent);
        return this;
    }

    public NIP60 createRedemptionQuoteEvent(@NonNull CashuQuote quote) {
        if (quote == null) {
            throw new NullPointerException("quote is marked non-null but is null");
        }
        GenericEvent redemptionQuoteEvent = new GenericEventFactory<BaseTag>(this.getSender(), Kind.RESERVED_CASHU_WALLET_TOKENS.getValue(), this.getRedemptionQuoteEventTags(quote), this.getRedemptionQuoteEventContent(quote)).create();
        this.updateEvent(redemptionQuoteEvent);
        return this;
    }

    public static BaseTag createMintTag(@NonNull CashuMint mint) {
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        return NIP60.createMintTag(mint.getUrl(), mint.getUnits() != null ? mint.getUnits().toArray(new String[0]) : null);
    }

    public static BaseTag createMintTag(@NonNull String mintUrl) {
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        return NIP60.createMintTag(mintUrl, null);
    }

    public static BaseTag createMintTag(@NonNull String mintUrl, String ... units) {
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(mintUrl);
        if (units != null && units.length > 0) {
            params.addAll(Arrays.asList(units));
        }
        return new BaseTagFactory("mint", params.toArray(new String[0])).create();
    }

    public static BaseTag createUnitTag(@NonNull String unit) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        return new BaseTagFactory("unit", unit).create();
    }

    public static BaseTag createPrivKeyTag(@NonNull String privKey) {
        if (privKey == null) {
            throw new NullPointerException("privKey is marked non-null but is null");
        }
        return new BaseTagFactory("privkey", privKey).create();
    }

    public static BaseTag createBalanceTag(@NonNull Integer balance, String unit) {
        if (balance == null) {
            throw new NullPointerException("balance is marked non-null but is null");
        }
        return new BaseTagFactory("balance", balance.toString(), unit).create();
    }

    public static BaseTag createDirectionTag(@NonNull SpendingHistory.Direction direction) {
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        return new BaseTagFactory("direction", direction.getValue()).create();
    }

    public static BaseTag createAmountTag(@NonNull Amount amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        return new BaseTagFactory("amount", amount.getAmount().toString(), amount.getUnit()).create();
    }

    public static BaseTag createExpirationTag(@NonNull Long expiration) {
        if (expiration == null) {
            throw new NullPointerException("expiration is marked non-null but is null");
        }
        return new BaseTagFactory("expiration", expiration.toString()).create();
    }

    private String getWalletEventContent(@NonNull CashuWallet wallet) {
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        ArrayList<BaseTag> tags = new ArrayList<BaseTag>();
        Map relayMap = wallet.getRelays();
        Set unitSet = relayMap.keySet();
        unitSet.forEach(u -> tags.add(NIP60.createBalanceTag(wallet.getBalance(), u)));
        tags.add(NIP60.createPrivKeyTag(wallet.getPrivateKey()));
        try {
            return NIP44.encrypt(this.getSender(), EventJsonMapper.mapper().writeValueAsString(tags), this.getSender().getPublicKey());
        }
        catch (JsonProcessingException ex) {
            throw new EventEncodingException("Failed to encode wallet content", (Throwable)ex);
        }
    }

    private String getTokenEventContent(@NonNull CashuToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        try {
            return NIP44.encrypt(this.getSender(), EventJsonMapper.mapper().writeValueAsString((Object)token), this.getSender().getPublicKey());
        }
        catch (JsonProcessingException ex) {
            throw new EventEncodingException("Failed to encode token content", (Throwable)ex);
        }
    }

    private String getRedemptionQuoteEventContent(@NonNull CashuQuote quote) {
        if (quote == null) {
            throw new NullPointerException("quote is marked non-null but is null");
        }
        return NIP44.encrypt(this.getSender(), quote.getId(), this.getSender().getPublicKey());
    }

    private String getSpendingHistoryEventContent(@NonNull SpendingHistory spendingHistory) {
        if (spendingHistory == null) {
            throw new NullPointerException("spendingHistory is marked non-null but is null");
        }
        ArrayList<BaseTag> tags = new ArrayList<BaseTag>();
        tags.add(NIP60.createDirectionTag(spendingHistory.getDirection()));
        tags.add(NIP60.createAmountTag(spendingHistory.getAmount()));
        tags.addAll(spendingHistory.getEventTags());
        return NIP44.encrypt(this.getSender(), this.getContent(tags), this.getSender().getPublicKey());
    }

    private String getContent(@NonNull List<BaseTag> tags) {
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        return "[" + tags.stream().map(tag -> new BaseTagEncoder(tag).encode()).collect(Collectors.joining(",")) + "]";
    }

    private List<BaseTag> getWalletEventTags(@NonNull CashuWallet wallet) {
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        ArrayList<BaseTag> tags = new ArrayList<BaseTag>();
        Map relayMap = wallet.getRelays();
        Set unitSet = relayMap.keySet();
        unitSet.forEach(u -> {
            tags.add(NIP60.createUnitTag(u));
            tags.add(NIP60.createBalanceTag(wallet.getBalance(), u));
        });
        tags.add(NIP01.createIdentifierTag(wallet.getId()));
        tags.add(NIP57.createDescriptionTag(wallet.getDescription()));
        tags.add(NIP60.createPrivKeyTag(wallet.getPrivateKey()));
        if (wallet.getMints() != null) {
            wallet.getMints().forEach(mint -> tags.add(NIP60.createMintTag(mint)));
        }
        Map relays = wallet.getRelays();
        relays.keySet().forEach(unit -> {
            Set relaySet = wallet.getRelays(unit);
            relaySet.forEach(relay -> tags.add(NIP42.createRelayTag(relay)));
        });
        return tags;
    }

    private List<BaseTag> getTokenEventTags(@NonNull CashuWallet wallet) {
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        ArrayList<BaseTag> tags = new ArrayList<BaseTag>();
        tags.add(NIP01.createAddressTag((Integer)Kind.WALLET.getValue(), this.getSender().getPublicKey(), NIP01.createIdentifierTag(wallet.getId()), null));
        return tags;
    }

    private List<BaseTag> getSpendingHistoryEventTags(@NonNull CashuWallet wallet) {
        if (wallet == null) {
            throw new NullPointerException("wallet is marked non-null but is null");
        }
        return this.getTokenEventTags(wallet);
    }

    private List<BaseTag> getRedemptionQuoteEventTags(@NonNull CashuQuote quote) {
        if (quote == null) {
            throw new NullPointerException("quote is marked non-null but is null");
        }
        ArrayList<BaseTag> tags = new ArrayList<BaseTag>();
        tags.add(NIP60.createExpirationTag(quote.getExpiration()));
        tags.add(NIP60.createMintTag(quote.getMint()));
        tags.add(NIP01.createAddressTag((Integer)Kind.WALLET.getValue(), this.getSender().getPublicKey(), NIP01.createIdentifierTag(quote.getWallet().getId()), null));
        return tags;
    }
}

