/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import nostr.api.EventNostr;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.base.Kind;
import nostr.base.Marker;
import nostr.base.Relay;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;
import nostr.id.Identity;

public class NIP65
extends EventNostr {
    public NIP65(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.setSender(sender);
    }

    public NIP65 createRelayListMetadataEvent(@NonNull List<Relay> relayList) {
        if (relayList == null) {
            throw new NullPointerException("relayList is marked non-null but is null");
        }
        List<BaseTag> relayUrlTags = relayList.stream().map(relay -> NIP65.createRelayUrlTag(relay)).toList();
        GenericEvent genericEvent = new GenericEventFactory<BaseTag>(this.getSender(), Kind.RELAY_LIST_METADATA.getValue(), relayUrlTags, "").create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP65 createRelayListMetadataEvent(@NonNull List<Relay> relayList, @NonNull Marker permission) {
        if (relayList == null) {
            throw new NullPointerException("relayList is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        List<BaseTag> relayUrlTags = relayList.stream().map(relay -> NIP65.createRelayUrlTag(relay, permission)).toList();
        GenericEvent genericEvent = new GenericEventFactory<BaseTag>(this.getSender(), Kind.RELAY_LIST_METADATA.getValue(), relayUrlTags, "").create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP65 createRelayListMetadataEvent(@NonNull Map<Relay, Marker> relayMarkerMap) {
        if (relayMarkerMap == null) {
            throw new NullPointerException("relayMarkerMap is marked non-null but is null");
        }
        ArrayList<BaseTag> relayUrlTags = new ArrayList<BaseTag>();
        for (Map.Entry<Relay, Marker> entry : relayMarkerMap.entrySet()) {
            relayUrlTags.add(NIP65.createRelayUrlTag(entry.getKey(), entry.getValue()));
        }
        GenericEvent genericEvent = new GenericEventFactory(this.getSender(), Kind.RELAY_LIST_METADATA.getValue(), relayUrlTags, "").create();
        this.updateEvent(genericEvent);
        return this;
    }

    public NIP65 addRelayUrlTag(@NonNull String url, @NonNull Marker permission) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        this.getEvent().addTag(NIP65.createRelayUrlTag(url, permission));
        return this;
    }

    public static BaseTag createRelayUrlTag(@NonNull Relay relay) {
        if (relay == null) {
            throw new NullPointerException("relay is marked non-null but is null");
        }
        return BaseTag.create((String)"r", (String[])new String[]{relay.getUri()});
    }

    public static BaseTag createRelayUrlTag(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return BaseTag.create((String)"r", (String[])new String[]{url});
    }

    public static BaseTag createRelayUrlTag(@NonNull String url, @NonNull Marker permission) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        return BaseTag.create((String)"r", (String[])new String[]{url, permission.getValue()});
    }

    public static BaseTag createRelayUrlTag(@NonNull Relay relay, @NonNull Marker permission) {
        if (relay == null) {
            throw new NullPointerException("relay is marked non-null but is null");
        }
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        return BaseTag.create((String)"r", (String[])new String[]{relay.getUri(), permission.getValue()});
    }
}

