/*
 * Decompiled with CFR 0.152.
 */
package nostr.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import nostr.api.NostrIF;
import nostr.api.WebSocketClientHandler;
import nostr.api.client.NostrEventDispatcher;
import nostr.api.client.NostrRelayRegistry;
import nostr.api.client.NostrRequestDispatcher;
import nostr.api.client.NostrSubscriptionManager;
import nostr.api.client.WebSocketClientHandlerFactory;
import nostr.api.service.NoteService;
import nostr.api.service.impl.DefaultNoteService;
import nostr.base.IEvent;
import nostr.base.ISignable;
import nostr.base.RelayUri;
import nostr.base.SubscriptionId;
import nostr.client.WebSocketClientFactory;
import nostr.client.springwebsocket.SpringWebSocketClient;
import nostr.client.springwebsocket.SpringWebSocketClientFactory;
import nostr.event.filter.Filters;
import nostr.event.impl.GenericEvent;
import nostr.id.Identity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NostrSpringWebSocketClient
implements NostrIF {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NostrSpringWebSocketClient.class);
    private final NostrRelayRegistry relayRegistry;
    private final NostrEventDispatcher eventDispatcher;
    private final NostrRequestDispatcher requestDispatcher;
    private final NostrSubscriptionManager subscriptionManager;
    private final WebSocketClientFactory clientFactory;
    private final NoteService noteService;
    private Identity sender;

    public NostrSpringWebSocketClient() {
        this(null, new DefaultNoteService(), (WebSocketClientFactory)new SpringWebSocketClientFactory());
    }

    public NostrSpringWebSocketClient(String relayName, String relayUri) {
        this();
        this.setRelays(Map.of(relayName, relayUri));
    }

    public NostrSpringWebSocketClient(@NonNull NoteService noteService) {
        this(null, noteService, (WebSocketClientFactory)new SpringWebSocketClientFactory());
        if (noteService == null) {
            throw new NullPointerException("noteService is marked non-null but is null");
        }
    }

    public NostrSpringWebSocketClient(@NonNull Identity sender, @NonNull NoteService noteService) {
        this(sender, noteService, (WebSocketClientFactory)new SpringWebSocketClientFactory());
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (noteService == null) {
            throw new NullPointerException("noteService is marked non-null but is null");
        }
    }

    public NostrSpringWebSocketClient(Identity sender, @NonNull NoteService noteService, @NonNull WebSocketClientFactory clientFactory) {
        if (noteService == null) {
            throw new NullPointerException("noteService is marked non-null but is null");
        }
        if (clientFactory == null) {
            throw new NullPointerException("clientFactory is marked non-null but is null");
        }
        this.sender = sender;
        this.noteService = noteService;
        this.clientFactory = clientFactory;
        this.relayRegistry = new NostrRelayRegistry(this.buildFactory());
        this.eventDispatcher = new NostrEventDispatcher(this.noteService, this.relayRegistry);
        this.requestDispatcher = new NostrRequestDispatcher(this.relayRegistry);
        this.subscriptionManager = new NostrSubscriptionManager(this.relayRegistry);
    }

    public NostrSpringWebSocketClient(@NonNull Identity sender) {
        this(sender, new DefaultNoteService());
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
    }

    public static NostrIF getInstance() {
        return InstanceHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NostrIF getInstance(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        NostrSpringWebSocketClient instance = InstanceHolder.INSTANCE;
        if (instance.getSender() == null) {
            NostrSpringWebSocketClient nostrSpringWebSocketClient = instance;
            synchronized (nostrSpringWebSocketClient) {
                if (instance.getSender() == null) {
                    instance.setSender(sender);
                }
            }
        }
        return instance;
    }

    @Override
    public NostrIF setSender(@NonNull Identity sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.sender = sender;
        return this;
    }

    @Override
    public NostrIF setRelays(@NonNull Map<String, String> relays) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        this.relayRegistry.registerRelays(relays);
        return this;
    }

    @Override
    public List<String> sendEvent(@NonNull IEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return this.eventDispatcher.send(event);
    }

    @Override
    public List<String> sendEvent(@NonNull IEvent event, Map<String, String> relays) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.setRelays(relays);
        return this.sendEvent(event);
    }

    @Override
    public List<String> sendRequest(@NonNull Filters filters, @NonNull String subscriptionId) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        return this.requestDispatcher.sendRequest(filters, SubscriptionId.of((String)subscriptionId));
    }

    @Override
    public List<String> sendRequest(@NonNull Filters filters, @NonNull String subscriptionId, Map<String, String> relays) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        this.setRelays(relays);
        return this.sendRequest(filters, subscriptionId);
    }

    @Override
    public List<String> sendRequest(@NonNull List<Filters> filtersList, @NonNull String subscriptionId, Map<String, String> relays) {
        if (filtersList == null) {
            throw new NullPointerException("filtersList is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        this.setRelays(relays);
        return this.sendRequest(filtersList, subscriptionId);
    }

    @Override
    public List<String> sendRequest(@NonNull List<Filters> filtersList, @NonNull String subscriptionId) {
        if (filtersList == null) {
            throw new NullPointerException("filtersList is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        return this.requestDispatcher.sendRequest(filtersList, subscriptionId);
    }

    public static List<String> sendRequest(@NonNull SpringWebSocketClient client, @NonNull Filters filters, @NonNull String subscriptionId) throws IOException {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        return NostrRequestDispatcher.sendRequest(client, filters, subscriptionId);
    }

    @Override
    public AutoCloseable subscribe(@NonNull Filters filters, @NonNull String subscriptionId, @NonNull Consumer<String> listener) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        return this.subscribe(filters, subscriptionId, listener, null);
    }

    @Override
    public AutoCloseable subscribe(@NonNull Filters filters, @NonNull String subscriptionId, @NonNull Consumer<String> listener, Consumer<Throwable> errorListener) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (subscriptionId == null) {
            throw new NullPointerException("subscriptionId is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        SubscriptionId id = SubscriptionId.of((String)subscriptionId);
        Consumer<Throwable> safeError = errorListener != null ? errorListener : throwable -> log.warn("Subscription error for {} on relays {}", new Object[]{id.value(), this.relayRegistry.getClientMap().keySet(), throwable});
        return this.subscriptionManager.subscribe(filters, id.value(), listener, safeError);
    }

    @Override
    public NostrIF sign(@NonNull Identity identity, @NonNull ISignable signable) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (signable == null) {
            throw new NullPointerException("signable is marked non-null but is null");
        }
        identity.sign(signable);
        return this;
    }

    @Override
    public boolean verify(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return this.eventDispatcher.verify(event);
    }

    @Override
    public Map<String, String> getRelays() {
        return this.relayRegistry.snapshotRelays();
    }

    public Map<String, Throwable> getLastSendFailures() {
        NoteService noteService = this.noteService;
        if (noteService instanceof DefaultNoteService) {
            DefaultNoteService d = (DefaultNoteService)noteService;
            return d.getLastFailures();
        }
        return new HashMap<String, Throwable>();
    }

    public Map<String, DefaultNoteService.FailureInfo> getLastSendFailureDetails() {
        NoteService noteService = this.noteService;
        if (noteService instanceof DefaultNoteService) {
            DefaultNoteService d = (DefaultNoteService)noteService;
            return d.getLastFailureDetails();
        }
        return new HashMap<String, DefaultNoteService.FailureInfo>();
    }

    public NostrSpringWebSocketClient onSendFailures(Consumer<Map<String, Throwable>> listener) {
        NoteService noteService = this.noteService;
        if (noteService instanceof DefaultNoteService) {
            DefaultNoteService d = (DefaultNoteService)noteService;
            d.setFailureListener(listener);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        this.relayRegistry.closeAll();
    }

    protected WebSocketClientHandler newWebSocketClientHandler(String relayName, RelayUri relayUri) throws ExecutionException, InterruptedException {
        return new WebSocketClientHandler(relayName, relayUri, this.clientFactory);
    }

    private WebSocketClientHandlerFactory buildFactory() {
        return this::newWebSocketClientHandler;
    }

    @Override
    @Generated
    public Identity getSender() {
        return this.sender;
    }

    private static final class InstanceHolder {
        private static final NostrSpringWebSocketClient INSTANCE = new NostrSpringWebSocketClient();

        private InstanceHolder() {
        }
    }
}

