/*
 * Decompiled with CFR 0.152.
 */
package nostr.api.nip57;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import nostr.api.factory.impl.BaseTagFactory;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.event.BaseTag;

public final class NIP57TagFactory {
    private NIP57TagFactory() {
    }

    public static BaseTag lnurl(@NonNull String lnurl) {
        if (lnurl == null) {
            throw new NullPointerException("lnurl is marked non-null but is null");
        }
        return new BaseTagFactory("lnurl", lnurl).create();
    }

    public static BaseTag bolt11(@NonNull String bolt11) {
        if (bolt11 == null) {
            throw new NullPointerException("bolt11 is marked non-null but is null");
        }
        return new BaseTagFactory("bolt11", bolt11).create();
    }

    public static BaseTag preimage(@NonNull String preimage) {
        if (preimage == null) {
            throw new NullPointerException("preimage is marked non-null but is null");
        }
        return new BaseTagFactory("preimage", preimage).create();
    }

    public static BaseTag description(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        return new BaseTagFactory("description", description).create();
    }

    public static BaseTag descriptionHash(@NonNull String descriptionHashHex) {
        if (descriptionHashHex == null) {
            throw new NullPointerException("descriptionHashHex is marked non-null but is null");
        }
        return new BaseTagFactory("description_hash", descriptionHashHex).create();
    }

    public static BaseTag amount(@NonNull Number amount) {
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        return new BaseTagFactory("amount", amount.toString()).create();
    }

    public static BaseTag zapSender(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        return new BaseTagFactory("P", publicKey.toString()).create();
    }

    public static BaseTag zap(@NonNull PublicKey receiver, @NonNull List<Relay> relays, Integer weight) {
        if (receiver == null) {
            throw new NullPointerException("receiver is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(receiver.toString());
        relays.stream().map(Relay::getUri).forEach(params::add);
        if (weight != null) {
            params.add(weight.toString());
        }
        return BaseTag.create((String)"zap", params);
    }

    public static BaseTag zap(@NonNull PublicKey receiver, @NonNull List<Relay> relays) {
        if (receiver == null) {
            throw new NullPointerException("receiver is marked non-null but is null");
        }
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        return NIP57TagFactory.zap(receiver, relays, null);
    }
}

