/*
 * Decompiled with CFR 0.152.
 */
package nostr.api.nip57;

import java.util.List;
import lombok.NonNull;
import nostr.api.factory.impl.GenericEventFactory;
import nostr.api.nip01.NIP01TagFactory;
import nostr.api.nip57.NIP57TagFactory;
import nostr.api.nip57.ZapRequestParameters;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.event.BaseTag;
import nostr.event.entities.ZapRequest;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.RelaysTag;
import nostr.id.Identity;

public final class NIP57ZapRequestBuilder {
    private Identity defaultSender;

    public NIP57ZapRequestBuilder(Identity defaultSender) {
        this.defaultSender = defaultSender;
    }

    public void updateDefaultSender(Identity defaultSender) {
        this.defaultSender = defaultSender;
    }

    public GenericEvent buildFromZapRequest(@NonNull Identity sender, @NonNull ZapRequest zapRequest, @NonNull String content, PublicKey recipientPubKey, GenericEvent zappedEvent, BaseTag addressTag) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (zapRequest == null) {
            throw new NullPointerException("zapRequest is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        GenericEvent genericEvent = this.initialiseZapRequest(sender, content);
        this.populateCommonZapRequestTags(genericEvent, zapRequest.getRelaysTag(), zapRequest.getAmount(), zapRequest.getLnUrl(), recipientPubKey, zappedEvent, addressTag);
        return genericEvent;
    }

    public GenericEvent buildFromZapRequest(@NonNull ZapRequest zapRequest, @NonNull String content, PublicKey recipientPubKey, GenericEvent zappedEvent, BaseTag addressTag) {
        if (zapRequest == null) {
            throw new NullPointerException("zapRequest is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return this.buildFromZapRequest(this.resolveSender(null), zapRequest, content, recipientPubKey, zappedEvent, addressTag);
    }

    public GenericEvent build(@NonNull ZapRequestParameters parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        GenericEvent genericEvent = this.initialiseZapRequest(parameters.getSender(), parameters.contentOrDefault());
        this.populateCommonZapRequestTags(genericEvent, parameters.determineRelaysTag(), parameters.getAmount(), parameters.getLnUrl(), parameters.getRecipientPubKey(), parameters.getZappedEvent(), parameters.getAddressTag());
        return genericEvent;
    }

    public GenericEvent buildFromParameters(Long amount, String lnUrl, BaseTag relaysTag, String content, PublicKey recipientPubKey, GenericEvent zappedEvent, BaseTag addressTag) {
        if (!(relaysTag instanceof RelaysTag)) {
            throw new IllegalArgumentException("tag must be of type RelaysTag");
        }
        GenericEvent genericEvent = this.initialiseZapRequest(this.resolveSender(null), content);
        this.populateCommonZapRequestTags(genericEvent, (RelaysTag)relaysTag, amount, lnUrl, recipientPubKey, zappedEvent, addressTag);
        return genericEvent;
    }

    public GenericEvent buildFromParameters(Long amount, String lnUrl, List<Relay> relays, String content, PublicKey recipientPubKey, GenericEvent zappedEvent, BaseTag addressTag) {
        return this.buildFromParameters(amount, lnUrl, (BaseTag)new RelaysTag(relays), content, recipientPubKey, zappedEvent, addressTag);
    }

    public GenericEvent buildSimpleZapRequest(Long amount, String lnUrl, List<String> relays, String content, PublicKey recipientPubKey) {
        return this.buildFromParameters(amount, lnUrl, (BaseTag)new RelaysTag(relays.stream().map(Relay::new).toList()), content, recipientPubKey, null, null);
    }

    private GenericEvent initialiseZapRequest(Identity sender, String content) {
        return new GenericEventFactory(this.resolveSender(sender), Kind.ZAP_REQUEST.getValue(), content == null ? "" : content).create();
    }

    private void populateCommonZapRequestTags(GenericEvent event, RelaysTag relaysTag, Number amount, String lnUrl, PublicKey recipientPubKey, GenericEvent zappedEvent, BaseTag addressTag) {
        event.addTag((BaseTag)relaysTag);
        event.addTag(NIP57TagFactory.amount(amount));
        event.addTag(NIP57TagFactory.lnurl(lnUrl));
        if (recipientPubKey != null) {
            event.addTag(NIP01TagFactory.pubKeyTag(recipientPubKey));
        }
        if (zappedEvent != null) {
            event.addTag(NIP01TagFactory.eventTag(zappedEvent.getId()));
        }
        if (addressTag != null) {
            if (!"a".equals(addressTag.getCode())) {
                throw new IllegalArgumentException("tag must be of type AddressTag");
            }
            event.addTag(addressTag);
        }
    }

    private Identity resolveSender(Identity override) {
        Identity resolved;
        Identity identity = resolved = override != null ? override : this.defaultSender;
        if (resolved == null) {
            throw new IllegalStateException("Sender identity is required to build zap requests");
        }
        return resolved;
    }
}

