/*
 * Decompiled with CFR 0.152.
 */
package nostr.api.service.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import nostr.api.WebSocketClientHandler;
import nostr.api.service.NoteService;
import nostr.base.IEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNoteService
implements NoteService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultNoteService.class);
    private final ThreadLocal<Map<String, Throwable>> lastFailures = ThreadLocal.withInitial(HashMap::new);
    private final ThreadLocal<Map<String, FailureInfo>> lastFailureDetails = ThreadLocal.withInitial(HashMap::new);
    private Consumer<Map<String, Throwable>> failureListener;

    public Map<String, Throwable> getLastFailures() {
        return new HashMap<String, Throwable>(this.lastFailures.get());
    }

    public Map<String, FailureInfo> getLastFailureDetails() {
        return new HashMap<String, FailureInfo>(this.lastFailureDetails.get());
    }

    public void setFailureListener(Consumer<Map<String, Throwable>> listener) {
        this.failureListener = listener;
    }

    @Override
    public List<String> send(@NonNull IEvent event, @NonNull Map<String, WebSocketClientHandler> clients) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (clients == null) {
            throw new NullPointerException("clients is marked non-null but is null");
        }
        ArrayList<String> responses = new ArrayList<String>();
        HashMap<String, RuntimeException> failures = new HashMap<String, RuntimeException>();
        HashMap<String, FailureInfo> details = new HashMap<String, FailureInfo>();
        RuntimeException lastFailure = null;
        for (Map.Entry<String, WebSocketClientHandler> entry : clients.entrySet()) {
            String relayName = entry.getKey();
            WebSocketClientHandler client = entry.getValue();
            try {
                responses.addAll(client.sendEvent(event));
            }
            catch (RuntimeException e) {
                failures.put(relayName, e);
                details.put(relayName, FailureInfo.from(relayName, client.getRelayUri().toString(), e));
                lastFailure = e;
                log.warn("Failed to send event on relay {}: {}", (Object)relayName, (Object)e.getMessage());
            }
        }
        this.lastFailures.set(failures);
        this.lastFailureDetails.set(details);
        if (this.failureListener != null && !failures.isEmpty()) {
            try {
                this.failureListener.accept(new HashMap(failures));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (responses.isEmpty() && lastFailure != null) {
            throw lastFailure;
        }
        return responses.stream().distinct().toList();
    }

    public static final class FailureInfo {
        public final long timestampEpochMillis;
        public final String relayName;
        public final String relayUri;
        public final String exceptionClass;
        public final String message;
        public final String rootCauseClass;
        public final String rootCauseMessage;

        private FailureInfo(long ts, String relayName, String relayUri, String cls, String msg, String rootCls, String rootMsg) {
            this.timestampEpochMillis = ts;
            this.relayName = relayName;
            this.relayUri = relayUri;
            this.exceptionClass = cls;
            this.message = msg;
            this.rootCauseClass = rootCls;
            this.rootCauseMessage = rootMsg;
        }

        private static Throwable root(Throwable t) {
            Throwable r;
            for (r = t; r.getCause() != null && r.getCause() != r; r = r.getCause()) {
            }
            return r;
        }

        public static FailureInfo from(String relayName, String relayUri, Throwable t) {
            Throwable r = FailureInfo.root(t);
            return new FailureInfo(Instant.now().toEpochMilli(), relayName, relayUri, t.getClass().getName(), String.valueOf(t.getMessage()), r.getClass().getName(), String.valueOf(r.getMessage()));
        }
    }
}

