/*
 * Decompiled with CFR 0.152.
 */
package nostr.base;

import lombok.Generated;
import nostr.base.BaseKey;
import nostr.base.KeyType;
import nostr.crypto.bech32.Bech32Prefix;
import nostr.crypto.schnorr.Schnorr;
import nostr.util.NostrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateKey
extends BaseKey {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrivateKey.class);

    public PrivateKey(byte[] rawData) {
        super(KeyType.PRIVATE, rawData, Bech32Prefix.NSEC);
        log.debug("Created private key from byte array");
    }

    public PrivateKey(String hexPrivKey) {
        super(KeyType.PRIVATE, NostrUtil.hexToBytes((String)hexPrivKey), Bech32Prefix.NSEC);
        log.debug("Created private key from hex string");
    }

    public static PrivateKey generateRandomPrivKey() {
        PrivateKey key = new PrivateKey(Schnorr.generatePrivateKey());
        log.debug("Generated new random private key");
        return key;
    }
}

