/*
 * Decompiled with CFR 0.152.
 */
package nostr.base;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Relay {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Relay.class);
    private String scheme;
    private String host;
    private RelayInformationDocument informationDocument;

    public Relay(@NonNull String uri) {
        this(uri, new RelayInformationDocument());
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
    }

    public Relay(@NonNull String uri, RelayInformationDocument doc) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.informationDocument = doc;
        String[] s = uri.split("://", 2);
        if (s.length != 2) {
            throw new RuntimeException("uri must contain scheme and host, passed in uri: \"" + uri + "\"");
        }
        this.scheme = s[0];
        this.host = s[1];
        log.debug("Created relay with scheme {} and host {}", (Object)this.scheme, (Object)this.host);
    }

    public List<Integer> getSupportedNips() {
        return this.getInformationDocument().getSupportedNips();
    }

    public void addNipSupport(int nip) {
        this.getSupportedNips().add(nip);
    }

    public String getName() {
        return this.getInformationDocument().getName();
    }

    public String getUri() {
        return this.scheme + "://" + this.host;
    }

    public String getHttpUri() {
        return this.scheme.replaceFirst("ws", "http") + "://" + this.host;
    }

    @Generated
    public String getScheme() {
        return this.scheme;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public RelayInformationDocument getInformationDocument() {
        return this.informationDocument;
    }

    @Generated
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setInformationDocument(RelayInformationDocument informationDocument) {
        this.informationDocument = informationDocument;
    }

    @Generated
    public String toString() {
        return "Relay(scheme=" + this.getScheme() + ", host=" + this.getHost() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Relay)) {
            return false;
        }
        Relay other = (Relay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        return !(this$host == null ? other$host != null : !this$host.equals(other$host));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Relay;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        return result;
    }

    @Generated
    public Relay(String scheme, String host, RelayInformationDocument informationDocument) {
        this.scheme = scheme;
        this.host = host;
        this.informationDocument = informationDocument;
    }

    public static class RelayInformationDocument {
        @JsonProperty
        private String name;
        @JsonProperty
        private String description;
        @JsonProperty
        private String pubkey;
        @JsonProperty
        @JsonIgnoreProperties(ignoreUnknown=true)
        private String id;
        @JsonProperty
        @JsonIgnoreProperties(ignoreUnknown=true)
        private String contact;
        @JsonProperty(value="supported_nips")
        @JsonIgnoreProperties(ignoreUnknown=true)
        private List<Integer> supportedNips;
        @JsonProperty(value="supported_nip_extensions")
        @JsonIgnoreProperties(ignoreUnknown=true)
        private List<String> supportedNipExtensions;
        @JsonProperty
        @JsonIgnoreProperties(ignoreUnknown=true)
        private String software;
        @JsonProperty
        @JsonIgnoreProperties(ignoreUnknown=true)
        private String version;
        @JsonProperty
        @JsonIgnoreProperties(ignoreUnknown=true)
        private Limitation limitation;
        @JsonProperty(value="payments_url")
        private String paymentsUrl;
        @JsonProperty
        @JsonIgnoreProperties(ignoreUnknown=true)
        private Fees fees;

        @Generated
        private static List<Integer> $default$supportedNips() {
            return new ArrayList<Integer>();
        }

        @Generated
        private static List<String> $default$supportedNipExtensions() {
            return new ArrayList<String>();
        }

        @Generated
        public static RelayInformationDocumentBuilder builder() {
            return new RelayInformationDocumentBuilder();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getPubkey() {
            return this.pubkey;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getContact() {
            return this.contact;
        }

        @Generated
        public List<Integer> getSupportedNips() {
            return this.supportedNips;
        }

        @Generated
        public List<String> getSupportedNipExtensions() {
            return this.supportedNipExtensions;
        }

        @Generated
        public String getSoftware() {
            return this.software;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public Limitation getLimitation() {
            return this.limitation;
        }

        @Generated
        public String getPaymentsUrl() {
            return this.paymentsUrl;
        }

        @Generated
        public Fees getFees() {
            return this.fees;
        }

        @JsonProperty
        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty
        @Generated
        public void setPubkey(String pubkey) {
            this.pubkey = pubkey;
        }

        @JsonProperty
        @JsonIgnoreProperties(ignoreUnknown=true)
        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        @JsonIgnoreProperties(ignoreUnknown=true)
        @Generated
        public void setContact(String contact) {
            this.contact = contact;
        }

        @JsonProperty(value="supported_nips")
        @JsonIgnoreProperties(ignoreUnknown=true)
        @Generated
        public void setSupportedNips(List<Integer> supportedNips) {
            this.supportedNips = supportedNips;
        }

        @JsonProperty(value="supported_nip_extensions")
        @JsonIgnoreProperties(ignoreUnknown=true)
        @Generated
        public void setSupportedNipExtensions(List<String> supportedNipExtensions) {
            this.supportedNipExtensions = supportedNipExtensions;
        }

        @JsonProperty
        @JsonIgnoreProperties(ignoreUnknown=true)
        @Generated
        public void setSoftware(String software) {
            this.software = software;
        }

        @JsonProperty
        @JsonIgnoreProperties(ignoreUnknown=true)
        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @JsonProperty
        @JsonIgnoreProperties(ignoreUnknown=true)
        @Generated
        public void setLimitation(Limitation limitation) {
            this.limitation = limitation;
        }

        @JsonProperty(value="payments_url")
        @Generated
        public void setPaymentsUrl(String paymentsUrl) {
            this.paymentsUrl = paymentsUrl;
        }

        @JsonProperty
        @JsonIgnoreProperties(ignoreUnknown=true)
        @Generated
        public void setFees(Fees fees) {
            this.fees = fees;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelayInformationDocument)) {
                return false;
            }
            RelayInformationDocument other = (RelayInformationDocument)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$pubkey = this.getPubkey();
            String other$pubkey = other.getPubkey();
            if (this$pubkey == null ? other$pubkey != null : !this$pubkey.equals(other$pubkey)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$contact = this.getContact();
            String other$contact = other.getContact();
            if (this$contact == null ? other$contact != null : !this$contact.equals(other$contact)) {
                return false;
            }
            List<Integer> this$supportedNips = this.getSupportedNips();
            List<Integer> other$supportedNips = other.getSupportedNips();
            if (this$supportedNips == null ? other$supportedNips != null : !((Object)this$supportedNips).equals(other$supportedNips)) {
                return false;
            }
            List<String> this$supportedNipExtensions = this.getSupportedNipExtensions();
            List<String> other$supportedNipExtensions = other.getSupportedNipExtensions();
            if (this$supportedNipExtensions == null ? other$supportedNipExtensions != null : !((Object)this$supportedNipExtensions).equals(other$supportedNipExtensions)) {
                return false;
            }
            String this$software = this.getSoftware();
            String other$software = other.getSoftware();
            if (this$software == null ? other$software != null : !this$software.equals(other$software)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            Limitation this$limitation = this.getLimitation();
            Limitation other$limitation = other.getLimitation();
            if (this$limitation == null ? other$limitation != null : !((Object)this$limitation).equals(other$limitation)) {
                return false;
            }
            String this$paymentsUrl = this.getPaymentsUrl();
            String other$paymentsUrl = other.getPaymentsUrl();
            if (this$paymentsUrl == null ? other$paymentsUrl != null : !this$paymentsUrl.equals(other$paymentsUrl)) {
                return false;
            }
            Fees this$fees = this.getFees();
            Fees other$fees = other.getFees();
            return !(this$fees == null ? other$fees != null : !((Object)this$fees).equals(other$fees));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RelayInformationDocument;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $pubkey = this.getPubkey();
            result = result * 59 + ($pubkey == null ? 43 : $pubkey.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $contact = this.getContact();
            result = result * 59 + ($contact == null ? 43 : $contact.hashCode());
            List<Integer> $supportedNips = this.getSupportedNips();
            result = result * 59 + ($supportedNips == null ? 43 : ((Object)$supportedNips).hashCode());
            List<String> $supportedNipExtensions = this.getSupportedNipExtensions();
            result = result * 59 + ($supportedNipExtensions == null ? 43 : ((Object)$supportedNipExtensions).hashCode());
            String $software = this.getSoftware();
            result = result * 59 + ($software == null ? 43 : $software.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            Limitation $limitation = this.getLimitation();
            result = result * 59 + ($limitation == null ? 43 : ((Object)$limitation).hashCode());
            String $paymentsUrl = this.getPaymentsUrl();
            result = result * 59 + ($paymentsUrl == null ? 43 : $paymentsUrl.hashCode());
            Fees $fees = this.getFees();
            result = result * 59 + ($fees == null ? 43 : ((Object)$fees).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Relay.RelayInformationDocument(name=" + this.getName() + ", description=" + this.getDescription() + ", pubkey=" + this.getPubkey() + ", id=" + this.getId() + ", contact=" + this.getContact() + ", supportedNips=" + String.valueOf(this.getSupportedNips()) + ", supportedNipExtensions=" + String.valueOf(this.getSupportedNipExtensions()) + ", software=" + this.getSoftware() + ", version=" + this.getVersion() + ", limitation=" + String.valueOf(this.getLimitation()) + ", paymentsUrl=" + this.getPaymentsUrl() + ", fees=" + String.valueOf(this.getFees()) + ")";
        }

        @Generated
        public RelayInformationDocument() {
            this.supportedNips = RelayInformationDocument.$default$supportedNips();
            this.supportedNipExtensions = RelayInformationDocument.$default$supportedNipExtensions();
        }

        @Generated
        public RelayInformationDocument(String name, String description, String pubkey, String id, String contact, List<Integer> supportedNips, List<String> supportedNipExtensions, String software, String version, Limitation limitation, String paymentsUrl, Fees fees) {
            this.name = name;
            this.description = description;
            this.pubkey = pubkey;
            this.id = id;
            this.contact = contact;
            this.supportedNips = supportedNips;
            this.supportedNipExtensions = supportedNipExtensions;
            this.software = software;
            this.version = version;
            this.limitation = limitation;
            this.paymentsUrl = paymentsUrl;
            this.fees = fees;
        }

        @Generated
        public static class RelayInformationDocumentBuilder {
            @Generated
            private String name;
            @Generated
            private String description;
            @Generated
            private String pubkey;
            @Generated
            private String id;
            @Generated
            private String contact;
            @Generated
            private boolean supportedNips$set;
            @Generated
            private List<Integer> supportedNips$value;
            @Generated
            private boolean supportedNipExtensions$set;
            @Generated
            private List<String> supportedNipExtensions$value;
            @Generated
            private String software;
            @Generated
            private String version;
            @Generated
            private Limitation limitation;
            @Generated
            private String paymentsUrl;
            @Generated
            private Fees fees;

            @Generated
            RelayInformationDocumentBuilder() {
            }

            @JsonProperty
            @Generated
            public RelayInformationDocumentBuilder name(String name) {
                this.name = name;
                return this;
            }

            @JsonProperty
            @Generated
            public RelayInformationDocumentBuilder description(String description) {
                this.description = description;
                return this;
            }

            @JsonProperty
            @Generated
            public RelayInformationDocumentBuilder pubkey(String pubkey) {
                this.pubkey = pubkey;
                return this;
            }

            @JsonProperty
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public RelayInformationDocumentBuilder id(String id) {
                this.id = id;
                return this;
            }

            @JsonProperty
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public RelayInformationDocumentBuilder contact(String contact) {
                this.contact = contact;
                return this;
            }

            @JsonProperty(value="supported_nips")
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public RelayInformationDocumentBuilder supportedNips(List<Integer> supportedNips) {
                this.supportedNips$value = supportedNips;
                this.supportedNips$set = true;
                return this;
            }

            @JsonProperty(value="supported_nip_extensions")
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public RelayInformationDocumentBuilder supportedNipExtensions(List<String> supportedNipExtensions) {
                this.supportedNipExtensions$value = supportedNipExtensions;
                this.supportedNipExtensions$set = true;
                return this;
            }

            @JsonProperty
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public RelayInformationDocumentBuilder software(String software) {
                this.software = software;
                return this;
            }

            @JsonProperty
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public RelayInformationDocumentBuilder version(String version) {
                this.version = version;
                return this;
            }

            @JsonProperty
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public RelayInformationDocumentBuilder limitation(Limitation limitation) {
                this.limitation = limitation;
                return this;
            }

            @JsonProperty(value="payments_url")
            @Generated
            public RelayInformationDocumentBuilder paymentsUrl(String paymentsUrl) {
                this.paymentsUrl = paymentsUrl;
                return this;
            }

            @JsonProperty
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public RelayInformationDocumentBuilder fees(Fees fees) {
                this.fees = fees;
                return this;
            }

            @Generated
            public RelayInformationDocument build() {
                List<Integer> supportedNips$value = this.supportedNips$value;
                if (!this.supportedNips$set) {
                    supportedNips$value = RelayInformationDocument.$default$supportedNips();
                }
                List<String> supportedNipExtensions$value = this.supportedNipExtensions$value;
                if (!this.supportedNipExtensions$set) {
                    supportedNipExtensions$value = RelayInformationDocument.$default$supportedNipExtensions();
                }
                return new RelayInformationDocument(this.name, this.description, this.pubkey, this.id, this.contact, supportedNips$value, supportedNipExtensions$value, this.software, this.version, this.limitation, this.paymentsUrl, this.fees);
            }

            @Generated
            public String toString() {
                return "Relay.RelayInformationDocument.RelayInformationDocumentBuilder(name=" + this.name + ", description=" + this.description + ", pubkey=" + this.pubkey + ", id=" + this.id + ", contact=" + this.contact + ", supportedNips$value=" + String.valueOf(this.supportedNips$value) + ", supportedNipExtensions$value=" + String.valueOf(this.supportedNipExtensions$value) + ", software=" + this.software + ", version=" + this.version + ", limitation=" + String.valueOf(this.limitation) + ", paymentsUrl=" + this.paymentsUrl + ", fees=" + String.valueOf(this.fees) + ")";
            }
        }

        public static class Limitation {
            @JsonProperty(value="max_message_length")
            @JsonIgnoreProperties(ignoreUnknown=true)
            private int maxMessageLength;
            @JsonProperty(value="max_subscriptions")
            @JsonIgnoreProperties(ignoreUnknown=true)
            private int maxSubscriptions;
            @JsonProperty(value="max_filters")
            @JsonIgnoreProperties(ignoreUnknown=true)
            private int maxFilters;
            @JsonProperty(value="max_limit")
            @JsonIgnoreProperties(ignoreUnknown=true)
            private int maxLimit;
            @JsonProperty(value="max_subid_length")
            @JsonIgnoreProperties(ignoreUnknown=true)
            private int maxSubIdLength;
            @JsonProperty(value="min_prefix")
            @JsonIgnoreProperties(ignoreUnknown=true)
            private int minPrefix;
            @JsonProperty(value="max_event_tags")
            @JsonIgnoreProperties(ignoreUnknown=true)
            private int maxEventTags;
            @JsonProperty(value="max_content_length")
            @JsonIgnoreProperties(ignoreUnknown=true)
            private int maxContentLength;
            @JsonProperty(value="min_pow_difficulty")
            @JsonIgnoreProperties(ignoreUnknown=true)
            private int minPowDifficulty;
            @JsonProperty(value="auth_required")
            @JsonIgnoreProperties(ignoreUnknown=true)
            private boolean authRequired;
            @JsonProperty(value="payment_required")
            @JsonIgnoreProperties(ignoreUnknown=true)
            private boolean paymentRequired;

            @Generated
            public Limitation() {
            }

            @Generated
            public int getMaxMessageLength() {
                return this.maxMessageLength;
            }

            @Generated
            public int getMaxSubscriptions() {
                return this.maxSubscriptions;
            }

            @Generated
            public int getMaxFilters() {
                return this.maxFilters;
            }

            @Generated
            public int getMaxLimit() {
                return this.maxLimit;
            }

            @Generated
            public int getMaxSubIdLength() {
                return this.maxSubIdLength;
            }

            @Generated
            public int getMinPrefix() {
                return this.minPrefix;
            }

            @Generated
            public int getMaxEventTags() {
                return this.maxEventTags;
            }

            @Generated
            public int getMaxContentLength() {
                return this.maxContentLength;
            }

            @Generated
            public int getMinPowDifficulty() {
                return this.minPowDifficulty;
            }

            @Generated
            public boolean isAuthRequired() {
                return this.authRequired;
            }

            @Generated
            public boolean isPaymentRequired() {
                return this.paymentRequired;
            }

            @JsonProperty(value="max_message_length")
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public void setMaxMessageLength(int maxMessageLength) {
                this.maxMessageLength = maxMessageLength;
            }

            @JsonProperty(value="max_subscriptions")
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public void setMaxSubscriptions(int maxSubscriptions) {
                this.maxSubscriptions = maxSubscriptions;
            }

            @JsonProperty(value="max_filters")
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public void setMaxFilters(int maxFilters) {
                this.maxFilters = maxFilters;
            }

            @JsonProperty(value="max_limit")
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public void setMaxLimit(int maxLimit) {
                this.maxLimit = maxLimit;
            }

            @JsonProperty(value="max_subid_length")
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public void setMaxSubIdLength(int maxSubIdLength) {
                this.maxSubIdLength = maxSubIdLength;
            }

            @JsonProperty(value="min_prefix")
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public void setMinPrefix(int minPrefix) {
                this.minPrefix = minPrefix;
            }

            @JsonProperty(value="max_event_tags")
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public void setMaxEventTags(int maxEventTags) {
                this.maxEventTags = maxEventTags;
            }

            @JsonProperty(value="max_content_length")
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public void setMaxContentLength(int maxContentLength) {
                this.maxContentLength = maxContentLength;
            }

            @JsonProperty(value="min_pow_difficulty")
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public void setMinPowDifficulty(int minPowDifficulty) {
                this.minPowDifficulty = minPowDifficulty;
            }

            @JsonProperty(value="auth_required")
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public void setAuthRequired(boolean authRequired) {
                this.authRequired = authRequired;
            }

            @JsonProperty(value="payment_required")
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public void setPaymentRequired(boolean paymentRequired) {
                this.paymentRequired = paymentRequired;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Limitation)) {
                    return false;
                }
                Limitation other = (Limitation)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getMaxMessageLength() != other.getMaxMessageLength()) {
                    return false;
                }
                if (this.getMaxSubscriptions() != other.getMaxSubscriptions()) {
                    return false;
                }
                if (this.getMaxFilters() != other.getMaxFilters()) {
                    return false;
                }
                if (this.getMaxLimit() != other.getMaxLimit()) {
                    return false;
                }
                if (this.getMaxSubIdLength() != other.getMaxSubIdLength()) {
                    return false;
                }
                if (this.getMinPrefix() != other.getMinPrefix()) {
                    return false;
                }
                if (this.getMaxEventTags() != other.getMaxEventTags()) {
                    return false;
                }
                if (this.getMaxContentLength() != other.getMaxContentLength()) {
                    return false;
                }
                if (this.getMinPowDifficulty() != other.getMinPowDifficulty()) {
                    return false;
                }
                if (this.isAuthRequired() != other.isAuthRequired()) {
                    return false;
                }
                return this.isPaymentRequired() == other.isPaymentRequired();
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Limitation;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getMaxMessageLength();
                result = result * 59 + this.getMaxSubscriptions();
                result = result * 59 + this.getMaxFilters();
                result = result * 59 + this.getMaxLimit();
                result = result * 59 + this.getMaxSubIdLength();
                result = result * 59 + this.getMinPrefix();
                result = result * 59 + this.getMaxEventTags();
                result = result * 59 + this.getMaxContentLength();
                result = result * 59 + this.getMinPowDifficulty();
                result = result * 59 + (this.isAuthRequired() ? 79 : 97);
                result = result * 59 + (this.isPaymentRequired() ? 79 : 97);
                return result;
            }

            @Generated
            public String toString() {
                return "Relay.RelayInformationDocument.Limitation(maxMessageLength=" + this.getMaxMessageLength() + ", maxSubscriptions=" + this.getMaxSubscriptions() + ", maxFilters=" + this.getMaxFilters() + ", maxLimit=" + this.getMaxLimit() + ", maxSubIdLength=" + this.getMaxSubIdLength() + ", minPrefix=" + this.getMinPrefix() + ", maxEventTags=" + this.getMaxEventTags() + ", maxContentLength=" + this.getMaxContentLength() + ", minPowDifficulty=" + this.getMinPowDifficulty() + ", authRequired=" + this.isAuthRequired() + ", paymentRequired=" + this.isPaymentRequired() + ")";
            }
        }

        public static class Fees {
            @JsonProperty
            @JsonIgnoreProperties(ignoreUnknown=true)
            private List<AdmissionFee> admission;
            @JsonProperty
            @JsonIgnoreProperties(ignoreUnknown=true)
            private List<PublicationFee> publication;

            @Generated
            public Fees() {
            }

            @Generated
            public List<AdmissionFee> getAdmission() {
                return this.admission;
            }

            @Generated
            public List<PublicationFee> getPublication() {
                return this.publication;
            }

            @JsonProperty
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public void setAdmission(List<AdmissionFee> admission) {
                this.admission = admission;
            }

            @JsonProperty
            @JsonIgnoreProperties(ignoreUnknown=true)
            @Generated
            public void setPublication(List<PublicationFee> publication) {
                this.publication = publication;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Fees)) {
                    return false;
                }
                Fees other = (Fees)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<AdmissionFee> this$admission = this.getAdmission();
                List<AdmissionFee> other$admission = other.getAdmission();
                if (this$admission == null ? other$admission != null : !((Object)this$admission).equals(other$admission)) {
                    return false;
                }
                List<PublicationFee> this$publication = this.getPublication();
                List<PublicationFee> other$publication = other.getPublication();
                return !(this$publication == null ? other$publication != null : !((Object)this$publication).equals(other$publication));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Fees;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<AdmissionFee> $admission = this.getAdmission();
                result = result * 59 + ($admission == null ? 43 : ((Object)$admission).hashCode());
                List<PublicationFee> $publication = this.getPublication();
                result = result * 59 + ($publication == null ? 43 : ((Object)$publication).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Relay.RelayInformationDocument.Fees(admission=" + String.valueOf(this.getAdmission()) + ", publication=" + String.valueOf(this.getPublication()) + ")";
            }

            public static class PublicationFee {
                @JsonProperty
                @JsonIgnoreProperties(ignoreUnknown=true)
                private int amount;
                @JsonProperty
                @JsonIgnoreProperties(ignoreUnknown=true)
                private String unit;

                @Generated
                public PublicationFee() {
                }

                @Generated
                public int getAmount() {
                    return this.amount;
                }

                @Generated
                public String getUnit() {
                    return this.unit;
                }

                @JsonProperty
                @JsonIgnoreProperties(ignoreUnknown=true)
                @Generated
                public void setAmount(int amount) {
                    this.amount = amount;
                }

                @JsonProperty
                @JsonIgnoreProperties(ignoreUnknown=true)
                @Generated
                public void setUnit(String unit) {
                    this.unit = unit;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof PublicationFee)) {
                        return false;
                    }
                    PublicationFee other = (PublicationFee)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (this.getAmount() != other.getAmount()) {
                        return false;
                    }
                    String this$unit = this.getUnit();
                    String other$unit = other.getUnit();
                    return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof PublicationFee;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.getAmount();
                    String $unit = this.getUnit();
                    result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
                    return result;
                }

                @Generated
                public String toString() {
                    return "Relay.RelayInformationDocument.Fees.PublicationFee(amount=" + this.getAmount() + ", unit=" + this.getUnit() + ")";
                }
            }

            public static class AdmissionFee {
                @JsonProperty
                @JsonIgnoreProperties(ignoreUnknown=true)
                private int amount;
                @JsonProperty
                @JsonIgnoreProperties(ignoreUnknown=true)
                private String unit;

                @Generated
                public AdmissionFee() {
                }

                @Generated
                public int getAmount() {
                    return this.amount;
                }

                @Generated
                public String getUnit() {
                    return this.unit;
                }

                @JsonProperty
                @JsonIgnoreProperties(ignoreUnknown=true)
                @Generated
                public void setAmount(int amount) {
                    this.amount = amount;
                }

                @JsonProperty
                @JsonIgnoreProperties(ignoreUnknown=true)
                @Generated
                public void setUnit(String unit) {
                    this.unit = unit;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof AdmissionFee)) {
                        return false;
                    }
                    AdmissionFee other = (AdmissionFee)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (this.getAmount() != other.getAmount()) {
                        return false;
                    }
                    String this$unit = this.getUnit();
                    String other$unit = other.getUnit();
                    return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof AdmissionFee;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.getAmount();
                    String $unit = this.getUnit();
                    result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
                    return result;
                }

                @Generated
                public String toString() {
                    return "Relay.RelayInformationDocument.Fees.AdmissionFee(amount=" + this.getAmount() + ", unit=" + this.getUnit() + ")";
                }
            }
        }
    }
}

