/*
 * Decompiled with CFR 0.152.
 */
package nostr.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import lombok.Generated;
import nostr.base.PublicKey;
import nostr.util.NostrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Signature {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Signature.class);
    @JsonProperty(value="rawData")
    private byte[] rawData;
    @JsonIgnore
    private PublicKey pubKey;

    @JsonValue
    public String toString() {
        return NostrUtil.bytesToHex((byte[])this.rawData);
    }

    public static Signature fromString(String sig) {
        log.debug("Creating signature from string");
        Signature signature = new Signature();
        signature.setRawData(NostrUtil.hex128ToBytes((String)sig));
        return signature;
    }

    @Generated
    public byte[] getRawData() {
        return this.rawData;
    }

    @Generated
    public PublicKey getPubKey() {
        return this.pubKey;
    }

    @JsonProperty(value="rawData")
    @Generated
    public void setRawData(byte[] rawData) {
        this.rawData = rawData;
    }

    @JsonIgnore
    @Generated
    public void setPubKey(PublicKey pubKey) {
        this.pubKey = pubKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Signature)) {
            return false;
        }
        Signature other = (Signature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getRawData(), other.getRawData())) {
            return false;
        }
        PublicKey this$pubKey = this.getPubKey();
        PublicKey other$pubKey = other.getPubKey();
        return !(this$pubKey == null ? other$pubKey != null : !((Object)this$pubKey).equals(other$pubKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Signature;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getRawData());
        PublicKey $pubKey = this.getPubKey();
        result = result * 59 + ($pubKey == null ? 43 : ((Object)$pubKey).hashCode());
        return result;
    }

    @Generated
    public Signature() {
    }
}

