/*
 * Decompiled with CFR 0.152.
 */
package nostr.client.springwebsocket;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import lombok.NonNull;
import nostr.client.springwebsocket.WebSocketClientIF;
import nostr.event.BaseMessage;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
@Scope(value="prototype")
public class StandardWebSocketClient
extends TextWebSocketHandler
implements WebSocketClientIF {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StandardWebSocketClient.class);
    private static final Duration DEFAULT_AWAIT_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_POLL_INTERVAL = Duration.ofMillis(500L);
    @Value(value="${nostr.websocket.await-timeout-ms:60000}")
    private long awaitTimeoutMs;
    @Value(value="${nostr.websocket.poll-interval-ms:500}")
    private long pollIntervalMs;
    private final WebSocketSession clientSession;
    private List<String> events = new ArrayList<String>();
    private final AtomicBoolean completed = new AtomicBoolean(false);

    public StandardWebSocketClient(@Value(value="${nostr.relay.uri}") String relayUri) throws ExecutionException, InterruptedException {
        this.clientSession = (WebSocketSession)new org.springframework.web.socket.client.standard.StandardWebSocketClient().execute((WebSocketHandler)this, new WebSocketHttpHeaders(), URI.create(relayUri)).get();
    }

    StandardWebSocketClient(WebSocketSession clientSession, long awaitTimeoutMs, long pollIntervalMs) {
        if (clientSession == null) {
            throw new NullPointerException("clientSession must not be null");
        }
        if (awaitTimeoutMs <= 0L) {
            throw new IllegalArgumentException("awaitTimeoutMs must be positive");
        }
        if (pollIntervalMs <= 0L) {
            throw new IllegalArgumentException("pollIntervalMs must be positive");
        }
        this.clientSession = clientSession;
        this.awaitTimeoutMs = awaitTimeoutMs;
        this.pollIntervalMs = pollIntervalMs;
    }

    protected void handleTextMessage(@NonNull WebSocketSession session, TextMessage message) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        this.events.add((String)message.getPayload());
        this.completed.setRelease(true);
    }

    @Override
    public <T extends BaseMessage> List<String> send(T eventMessage) throws IOException {
        return this.send(eventMessage.encode());
    }

    @Override
    public List<String> send(String json) throws IOException {
        this.clientSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)json));
        Duration awaitTimeout = this.awaitTimeoutMs > 0L ? Duration.ofMillis(this.awaitTimeoutMs) : DEFAULT_AWAIT_TIMEOUT;
        Duration pollInterval = this.pollIntervalMs > 0L ? Duration.ofMillis(this.pollIntervalMs) : DEFAULT_POLL_INTERVAL;
        try {
            Awaitility.await().atMost(awaitTimeout).pollInterval(pollInterval).untilTrue(this.completed);
        }
        catch (ConditionTimeoutException e) {
            log.error("Timed out waiting for relay response", (Throwable)e);
            try {
                this.clientSession.close();
            }
            catch (IOException closeEx) {
                log.warn("Error closing session after timeout", (Throwable)closeEx);
            }
            this.events = new ArrayList<String>();
            this.completed.setRelease(false);
            return List.of();
        }
        List<String> eventList = List.copyOf(this.events);
        this.events = new ArrayList<String>();
        this.completed.setRelease(false);
        return eventList;
    }

    @Override
    public void close() throws IOException {
        if (this.clientSession != null) {
            boolean open = false;
            try {
                open = this.clientSession.isOpen();
            }
            catch (Exception e) {
                log.warn("Exception while checking if clientSession is open during close()", (Throwable)e);
            }
            if (open) {
                this.clientSession.close();
            }
        }
    }

    @Override
    @Deprecated
    public void closeSocket() throws IOException {
        this.close();
    }
}

