/*
 * Decompiled with CFR 0.152.
 */
package nostr.client.springwebsocket;

import java.io.IOException;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.client.springwebsocket.NostrRetryable;
import nostr.client.springwebsocket.WebSocketClientIF;
import nostr.event.BaseMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.retry.annotation.Recover;
import org.springframework.stereotype.Component;

@Component
public class SpringWebSocketClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringWebSocketClient.class);
    private final WebSocketClientIF webSocketClientIF;
    private final String relayUrl;

    public SpringWebSocketClient(@NonNull WebSocketClientIF webSocketClientIF, @Value(value="${nostr.relay.uri}") String relayUrl) {
        if (webSocketClientIF == null) {
            throw new NullPointerException("webSocketClientIF is marked non-null but is null");
        }
        this.webSocketClientIF = webSocketClientIF;
        this.relayUrl = relayUrl;
    }

    @NostrRetryable
    public List<String> send(@NonNull BaseMessage eventMessage) throws IOException {
        if (eventMessage == null) {
            throw new NullPointerException("eventMessage is marked non-null but is null");
        }
        String json = eventMessage.encode();
        log.debug("Sending {} to relay {} (size={} bytes)", new Object[]{eventMessage.getCommand(), this.relayUrl, json.length()});
        List<String> responses = this.webSocketClientIF.send(json);
        log.debug("Sent {} to relay {} with {} responses", new Object[]{eventMessage.getCommand(), this.relayUrl, responses.size()});
        return responses;
    }

    @NostrRetryable
    public List<String> send(@NonNull String json) throws IOException {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        log.debug("Sending message to relay {} (size={} bytes)", (Object)this.relayUrl, (Object)json.length());
        List<String> responses = this.webSocketClientIF.send(json);
        log.debug("Sent message to relay {} with {} responses", (Object)this.relayUrl, (Object)responses.size());
        return responses;
    }

    @Recover
    public List<String> recover(IOException ex, String json) throws IOException {
        log.error("Failed to send message to relay {} after retries (size={} bytes)", new Object[]{this.relayUrl, json.length(), ex});
        throw ex;
    }

    @Recover
    public List<String> recover(IOException ex, BaseMessage eventMessage) throws IOException {
        String json = eventMessage.encode();
        log.error("Failed to send {} to relay {} after retries (size={} bytes)", new Object[]{eventMessage.getCommand(), this.relayUrl, json.length(), ex});
        throw ex;
    }

    @Override
    public void close() throws IOException {
        log.debug("Closing WebSocket client for relay {}", (Object)this.relayUrl);
        this.webSocketClientIF.close();
        log.debug("WebSocket client closed for relay {}", (Object)this.relayUrl);
    }

    @Deprecated
    public void closeSocket() throws IOException {
        this.close();
    }

    @Generated
    public String getRelayUrl() {
        return this.relayUrl;
    }
}

