/*
 * Decompiled with CFR 0.152.
 */
package nostr.client.springwebsocket;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import nostr.client.springwebsocket.WebSocketClientIF;
import nostr.event.BaseMessage;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
@Scope(value="prototype")
public class StandardWebSocketClient
extends TextWebSocketHandler
implements WebSocketClientIF {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StandardWebSocketClient.class);
    private static final Duration DEFAULT_AWAIT_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_POLL_INTERVAL = Duration.ofMillis(500L);
    @Value(value="${nostr.websocket.await-timeout-ms:60000}")
    private long awaitTimeoutMs;
    @Value(value="${nostr.websocket.poll-interval-ms:500}")
    private long pollIntervalMs;
    private final WebSocketSession clientSession;
    private final AtomicBoolean completed = new AtomicBoolean(false);
    private final Object sendLock = new Object();
    private List<String> events = new ArrayList<String>();
    private volatile boolean awaitingResponse = false;
    private final Map<String, ListenerRegistration> listeners = new ConcurrentHashMap<String, ListenerRegistration>();
    private final AtomicBoolean connectionClosed = new AtomicBoolean(false);

    public StandardWebSocketClient(@Value(value="${nostr.relay.uri}") String relayUri) throws ExecutionException, InterruptedException {
        this.clientSession = (WebSocketSession)new org.springframework.web.socket.client.standard.StandardWebSocketClient().execute((WebSocketHandler)this, new WebSocketHttpHeaders(), URI.create(relayUri)).get();
    }

    StandardWebSocketClient(WebSocketSession clientSession, long awaitTimeoutMs, long pollIntervalMs) {
        if (clientSession == null) {
            throw new NullPointerException("clientSession must not be null");
        }
        if (awaitTimeoutMs <= 0L) {
            throw new IllegalArgumentException("awaitTimeoutMs must be positive");
        }
        if (pollIntervalMs <= 0L) {
            throw new IllegalArgumentException("pollIntervalMs must be positive");
        }
        this.clientSession = clientSession;
        this.awaitTimeoutMs = awaitTimeoutMs;
        this.pollIntervalMs = pollIntervalMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTextMessage(@NonNull WebSocketSession session, TextMessage message) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        this.dispatchMessage((String)message.getPayload());
        Object object = this.sendLock;
        synchronized (object) {
            if (this.awaitingResponse) {
                this.events.add((String)message.getPayload());
                this.completed.setRelease(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTransportError(@NonNull WebSocketSession session, @NonNull Throwable exception) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        log.warn("Transport error on WebSocket session", exception);
        this.notifyError(exception);
        Object object = this.sendLock;
        synchronized (object) {
            this.awaitingResponse = false;
            this.completed.setRelease(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnectionClosed(@NonNull WebSocketSession session, @NonNull CloseStatus status) throws Exception {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        super.afterConnectionClosed(session, status);
        if (this.connectionClosed.compareAndSet(false, true)) {
            this.notifyClose();
        }
        Object object = this.sendLock;
        synchronized (object) {
            this.awaitingResponse = false;
            this.completed.setRelease(true);
        }
    }

    @Override
    public <T extends BaseMessage> List<String> send(T eventMessage) throws IOException {
        return this.send(eventMessage.encode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> send(String json) throws IOException {
        Object object = this.sendLock;
        synchronized (object) {
            this.events = new ArrayList<String>();
            this.awaitingResponse = true;
            this.completed.setRelease(false);
            this.clientSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)json));
        }
        Duration awaitTimeout = this.awaitTimeoutMs > 0L ? Duration.ofMillis(this.awaitTimeoutMs) : DEFAULT_AWAIT_TIMEOUT;
        Duration pollInterval = this.pollIntervalMs > 0L ? Duration.ofMillis(this.pollIntervalMs) : DEFAULT_POLL_INTERVAL;
        try {
            Awaitility.await().atMost(awaitTimeout).pollInterval(pollInterval).untilTrue(this.completed);
        }
        catch (ConditionTimeoutException e) {
            log.error("Timed out waiting for relay response", (Throwable)e);
            try {
                this.clientSession.close();
            }
            catch (IOException closeEx) {
                log.warn("Error closing session after timeout", (Throwable)closeEx);
            }
            Object closeEx = this.sendLock;
            synchronized (closeEx) {
                this.events = new ArrayList<String>();
                this.awaitingResponse = false;
                this.completed.setRelease(false);
            }
            return List.of();
        }
        Object object2 = this.sendLock;
        synchronized (object2) {
            List<String> eventList = List.copyOf(this.events);
            this.events = new ArrayList<String>();
            this.awaitingResponse = false;
            this.completed.setRelease(false);
            return eventList;
        }
    }

    @Override
    public AutoCloseable subscribe(String requestJson, Consumer<String> messageListener, Consumer<Throwable> errorListener, Runnable closeListener) throws IOException {
        if (requestJson == null || messageListener == null || errorListener == null) {
            throw new NullPointerException("Subscription parameters must not be null");
        }
        if (!this.clientSession.isOpen()) {
            throw new IOException("WebSocket session is closed");
        }
        String listenerId = UUID.randomUUID().toString();
        this.listeners.put(listenerId, new ListenerRegistration(messageListener, errorListener, closeListener));
        try {
            this.clientSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)requestJson));
        }
        catch (IOException e) {
            this.listeners.remove(listenerId);
            throw e;
        }
        catch (RuntimeException e) {
            this.listeners.remove(listenerId);
            throw new IOException("Failed to send subscription payload", e);
        }
        return () -> this.listeners.remove(listenerId);
    }

    @Override
    public void close() throws IOException {
        if (this.clientSession != null) {
            boolean open = false;
            try {
                open = this.clientSession.isOpen();
            }
            catch (Exception e) {
                log.warn("Exception while checking if clientSession is open during close()", (Throwable)e);
            }
            if (open) {
                this.clientSession.close();
                if (this.connectionClosed.compareAndSet(false, true)) {
                    this.notifyClose();
                }
            }
        }
    }

    @Override
    @Deprecated
    public void closeSocket() throws IOException {
        this.close();
    }

    private void dispatchMessage(String payload) {
        this.listeners.values().forEach(listener -> this.safelyInvoke(listener.messageListener(), payload, (ListenerRegistration)listener));
    }

    private void notifyError(Throwable throwable) {
        this.listeners.values().forEach(listener -> this.safelyInvoke(listener.errorListener(), throwable, (ListenerRegistration)listener));
    }

    private void notifyClose() {
        this.listeners.values().forEach(listener -> this.safelyInvoke(listener.closeListener(), (ListenerRegistration)listener));
        this.listeners.clear();
    }

    private void safelyInvoke(Consumer<String> consumer, String payload, ListenerRegistration listener) {
        if (consumer == null) {
            return;
        }
        try {
            consumer.accept(payload);
        }
        catch (Exception e) {
            log.warn("Listener threw exception while handling message", (Throwable)e);
            this.safelyInvoke(listener.errorListener(), e, listener);
        }
    }

    private void safelyInvoke(Consumer<Throwable> consumer, Throwable throwable, ListenerRegistration ignored) {
        if (consumer == null) {
            return;
        }
        try {
            consumer.accept(throwable);
        }
        catch (Exception e) {
            log.warn("Listener error callback threw exception", (Throwable)e);
        }
    }

    private void safelyInvoke(Runnable runnable, ListenerRegistration listener) {
        if (runnable == null) {
            return;
        }
        try {
            runnable.run();
        }
        catch (Exception e) {
            log.warn("Listener close callback threw exception", (Throwable)e);
            this.safelyInvoke(listener.errorListener(), e, listener);
        }
    }

    private record ListenerRegistration(Consumer<String> messageListener, Consumer<Throwable> errorListener, Runnable closeListener) {
    }
}

