/*
 * Decompiled with CFR 0.152.
 */
package nostr.client.springwebsocket;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import nostr.client.springwebsocket.NostrRetryable;
import nostr.client.springwebsocket.WebSocketClientIF;
import nostr.event.BaseMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.retry.annotation.Recover;
import org.springframework.stereotype.Component;

@Component
public class SpringWebSocketClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringWebSocketClient.class);
    private final WebSocketClientIF webSocketClientIF;
    private final String relayUrl;

    public SpringWebSocketClient(@NonNull WebSocketClientIF webSocketClientIF, @Value(value="${nostr.relay.uri}") String relayUrl) {
        if (webSocketClientIF == null) {
            throw new NullPointerException("webSocketClientIF is marked non-null but is null");
        }
        this.webSocketClientIF = webSocketClientIF;
        this.relayUrl = relayUrl;
    }

    @NostrRetryable
    public List<String> send(@NonNull BaseMessage eventMessage) throws IOException {
        if (eventMessage == null) {
            throw new NullPointerException("eventMessage is marked non-null but is null");
        }
        String json = eventMessage.encode();
        log.debug("Sending {} to relay {} (size={} bytes)", new Object[]{eventMessage.getCommand(), this.relayUrl, json.length()});
        List<String> responses = this.webSocketClientIF.send(json);
        log.debug("Sent {} to relay {} with {} responses", new Object[]{eventMessage.getCommand(), this.relayUrl, responses.size()});
        return responses;
    }

    @NostrRetryable
    public List<String> send(@NonNull String json) throws IOException {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        log.debug("Sending message to relay {} (size={} bytes)", (Object)this.relayUrl, (Object)json.length());
        List<String> responses = this.webSocketClientIF.send(json);
        log.debug("Sent message to relay {} with {} responses", (Object)this.relayUrl, (Object)responses.size());
        return responses;
    }

    @NostrRetryable
    public AutoCloseable subscribe(@NonNull BaseMessage requestMessage, @NonNull Consumer<String> messageListener, @NonNull Consumer<Throwable> errorListener, Runnable closeListener) throws IOException {
        if (requestMessage == null) {
            throw new NullPointerException("requestMessage is marked non-null but is null");
        }
        Objects.requireNonNull(messageListener, "messageListener");
        Objects.requireNonNull(errorListener, "errorListener");
        String json = requestMessage.encode();
        log.debug("Subscribing with {} on relay {} (size={} bytes)", new Object[]{requestMessage.getCommand(), this.relayUrl, json.length()});
        AutoCloseable handle = this.webSocketClientIF.subscribe(json, messageListener, errorListener, closeListener);
        log.debug("Subscription established with {} on relay {}", (Object)requestMessage.getCommand(), (Object)this.relayUrl);
        return handle;
    }

    @NostrRetryable
    public AutoCloseable subscribe(@NonNull String json, @NonNull Consumer<String> messageListener, @NonNull Consumer<Throwable> errorListener, Runnable closeListener) throws IOException {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        Objects.requireNonNull(messageListener, "messageListener");
        Objects.requireNonNull(errorListener, "errorListener");
        log.debug("Subscribing with raw message to relay {} (size={} bytes)", (Object)this.relayUrl, (Object)json.length());
        AutoCloseable handle = this.webSocketClientIF.subscribe(json, messageListener, errorListener, closeListener);
        log.debug("Subscription established on relay {}", (Object)this.relayUrl);
        return handle;
    }

    private void logRecoveryFailure(String operation, int size, IOException ex) {
        log.error("Failed to {} to relay {} after retries (size={} bytes)", new Object[]{operation, this.relayUrl, size, ex});
    }

    private void logRecoveryFailure(String operation, String command, int size, IOException ex) {
        log.error("Failed to {} {} to relay {} after retries (size={} bytes)", new Object[]{operation, command, this.relayUrl, size, ex});
    }

    @Recover
    public List<String> recover(IOException ex, String json) throws IOException {
        this.logRecoveryFailure("send message", json.length(), ex);
        throw ex;
    }

    @Recover
    public AutoCloseable recoverSubscription(IOException ex, String json, Consumer<String> messageListener, Consumer<Throwable> errorListener, Runnable closeListener) throws IOException {
        this.logRecoveryFailure("subscribe with raw message", json.length(), ex);
        throw ex;
    }

    @Recover
    public AutoCloseable recoverSubscription(IOException ex, BaseMessage requestMessage, Consumer<String> messageListener, Consumer<Throwable> errorListener, Runnable closeListener) throws IOException {
        String json = requestMessage.encode();
        this.logRecoveryFailure("subscribe with", requestMessage.getCommand(), json.length(), ex);
        throw ex;
    }

    @Recover
    public List<String> recover(IOException ex, BaseMessage eventMessage) throws IOException {
        String json = eventMessage.encode();
        this.logRecoveryFailure("send", eventMessage.getCommand(), json.length(), ex);
        throw ex;
    }

    @Override
    public void close() throws IOException {
        log.debug("Closing WebSocket client for relay {}", (Object)this.relayUrl);
        this.webSocketClientIF.close();
        log.debug("WebSocket client closed for relay {}", (Object)this.relayUrl);
    }

    @Generated
    public String getRelayUrl() {
        return this.relayUrl;
    }
}

