/*
 * Decompiled with CFR 0.152.
 */
package nostr.encryption;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import nostr.crypto.nip44.EncryptedPayloads;
import nostr.encryption.MessageCipher;
import nostr.util.NostrUtil;

public class MessageCipher44
implements MessageCipher {
    private static final int NONCE_LENGTH = 32;
    private final byte[] senderPrivateKey;
    private final byte[] recipientPublicKey;

    @Override
    public String encrypt(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        try {
            byte[] convoKey = this.getConversationKey();
            byte[] nonce = this.generateNonce();
            return EncryptedPayloads.encrypt((String)message, (byte[])convoKey, (byte[])nonce);
        }
        catch (Exception e) {
            throw new RuntimeException("Encryption failed: " + e.getMessage(), e);
        }
    }

    @Override
    public String decrypt(@NonNull String payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        try {
            byte[] convoKey = this.getConversationKey();
            return EncryptedPayloads.decrypt((String)payload, (byte[])convoKey);
        }
        catch (Exception e) {
            throw new RuntimeException("Decryption failed: " + e.getMessage(), e);
        }
    }

    private byte[] getConversationKey() {
        try {
            return EncryptedPayloads.getConversationKey((String)NostrUtil.bytesToHex((byte[])this.senderPrivateKey), (String)("02" + NostrUtil.bytesToHex((byte[])this.recipientPublicKey)));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] generateNonce() {
        return NostrUtil.createRandomByteArray((int)32);
    }

    @Generated
    public byte[] getSenderPrivateKey() {
        return this.senderPrivateKey;
    }

    @Generated
    public byte[] getRecipientPublicKey() {
        return this.recipientPublicKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageCipher44)) {
            return false;
        }
        MessageCipher44 other = (MessageCipher44)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getSenderPrivateKey(), other.getSenderPrivateKey())) {
            return false;
        }
        return Arrays.equals(this.getRecipientPublicKey(), other.getRecipientPublicKey());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessageCipher44;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getSenderPrivateKey());
        result = result * 59 + Arrays.hashCode(this.getRecipientPublicKey());
        return result;
    }

    @Generated
    public String toString() {
        return "MessageCipher44(senderPrivateKey=" + Arrays.toString(this.getSenderPrivateKey()) + ", recipientPublicKey=" + Arrays.toString(this.getRecipientPublicKey()) + ")";
    }

    @Generated
    public MessageCipher44(byte[] senderPrivateKey, byte[] recipientPublicKey) {
        this.senderPrivateKey = senderPrivateKey;
        this.recipientPublicKey = recipientPublicKey;
    }
}

