/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.entities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Relay;
import nostr.event.entities.CashuMint;
import nostr.event.entities.CashuToken;

public class CashuWallet {
    private String id;
    private String name;
    private String description;
    private Integer balance;
    private String privateKey;
    private Set<CashuMint> mints;
    private Map<String, Set<Relay>> relays;
    private Set<CashuToken> tokens;

    public CashuWallet() {
        this.balance = 0;
        this.mints = new HashSet<CashuMint>();
        this.relays = new HashMap<String, Set<Relay>>();
        this.tokens = new HashSet<CashuToken>();
    }

    public void reset() {
        this.resetBalance();
        this.tokens = new HashSet<CashuToken>();
    }

    public void resetBalance() {
        this.balance = 0;
    }

    public void increaseBalance(Integer amount) {
        this.balance = this.balance + amount;
    }

    public void decreaseBalance(Integer amount) {
        this.balance = this.balance - amount;
    }

    public void addToken(@NonNull CashuToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        this.tokens.add(token);
        this.refreshBalance();
    }

    public void removeToken(@NonNull CashuToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        this.tokens.remove(token);
        this.refreshBalance();
    }

    public void addMint(@NonNull CashuMint mint) {
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        this.mints.add(mint);
    }

    public void removeMint(@NonNull CashuMint mint) {
        if (mint == null) {
            throw new NullPointerException("mint is marked non-null but is null");
        }
        this.mints.remove(mint);
    }

    public CashuMint getMint(@NonNull String mintUrl) {
        if (mintUrl == null) {
            throw new NullPointerException("mintUrl is marked non-null but is null");
        }
        return this.mints.stream().filter(mint -> mint.getUrl().equals(mintUrl)).findFirst().orElse(null);
    }

    public void addRelay(@NonNull String unit, @NonNull Relay relay) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (relay == null) {
            throw new NullPointerException("relay is marked non-null but is null");
        }
        Set<Relay> relaySet = this.relays.get(unit);
        if (relaySet == null) {
            relaySet = new HashSet<Relay>();
        }
        relaySet.add(relay);
        this.relays.put(unit, relaySet);
    }

    public void removeRelay(@NonNull String unit, @NonNull Relay relay) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (relay == null) {
            throw new NullPointerException("relay is marked non-null but is null");
        }
        Set<Relay> relaySet = this.relays.get(unit);
        if (relaySet == null) {
            return;
        }
        relaySet.remove(relay);
        if (relaySet.isEmpty()) {
            this.relays.remove(unit);
        } else {
            this.relays.put(unit, relaySet);
        }
    }

    public Set<Relay> getRelays(@NonNull String unit) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        return this.relays.get(unit);
    }

    public void refreshBalance() {
        int total = 0;
        for (CashuToken token : this.tokens) {
            total += token.calculateAmount().intValue();
        }
        this.setBalance(total);
    }

    @Generated
    public static CashuWalletBuilder builder() {
        return new CashuWalletBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Integer getBalance() {
        return this.balance;
    }

    @Generated
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public Set<CashuMint> getMints() {
        return this.mints;
    }

    @Generated
    public Map<String, Set<Relay>> getRelays() {
        return this.relays;
    }

    @Generated
    public Set<CashuToken> getTokens() {
        return this.tokens;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setBalance(Integer balance) {
        this.balance = balance;
    }

    @Generated
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    @Generated
    public void setMints(Set<CashuMint> mints) {
        this.mints = mints;
    }

    @Generated
    public void setRelays(Map<String, Set<Relay>> relays) {
        this.relays = relays;
    }

    @Generated
    public void setTokens(Set<CashuToken> tokens) {
        this.tokens = tokens;
    }

    @Generated
    public String toString() {
        return "CashuWallet(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", balance=" + this.getBalance() + ", privateKey=" + this.getPrivateKey() + ", mints=" + String.valueOf(this.getMints()) + ", relays=" + String.valueOf(this.getRelays()) + ", tokens=" + String.valueOf(this.getTokens()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CashuWallet)) {
            return false;
        }
        CashuWallet other = (CashuWallet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        return !(this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CashuWallet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        return result;
    }

    @Generated
    public CashuWallet(String id, String name, String description, Integer balance, String privateKey, Set<CashuMint> mints, Map<String, Set<Relay>> relays, Set<CashuToken> tokens) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.balance = balance;
        this.privateKey = privateKey;
        this.mints = mints;
        this.relays = relays;
        this.tokens = tokens;
    }

    @Generated
    public static class CashuWalletBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private Integer balance;
        @Generated
        private String privateKey;
        @Generated
        private Set<CashuMint> mints;
        @Generated
        private Map<String, Set<Relay>> relays;
        @Generated
        private Set<CashuToken> tokens;

        @Generated
        CashuWalletBuilder() {
        }

        @Generated
        public CashuWalletBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public CashuWalletBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public CashuWalletBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public CashuWalletBuilder balance(Integer balance) {
            this.balance = balance;
            return this;
        }

        @Generated
        public CashuWalletBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Generated
        public CashuWalletBuilder mints(Set<CashuMint> mints) {
            this.mints = mints;
            return this;
        }

        @Generated
        public CashuWalletBuilder relays(Map<String, Set<Relay>> relays) {
            this.relays = relays;
            return this;
        }

        @Generated
        public CashuWalletBuilder tokens(Set<CashuToken> tokens) {
            this.tokens = tokens;
            return this;
        }

        @Generated
        public CashuWallet build() {
            return new CashuWallet(this.id, this.name, this.description, this.balance, this.privateKey, this.mints, this.relays, this.tokens);
        }

        @Generated
        public String toString() {
            return "CashuWallet.CashuWalletBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", balance=" + this.balance + ", privateKey=" + this.privateKey + ", mints=" + String.valueOf(this.mints) + ", relays=" + String.valueOf(this.relays) + ", tokens=" + String.valueOf(this.tokens) + ")";
        }
    }
}

