/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.filter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import nostr.base.IEvent;
import nostr.event.filter.AbstractFilterable;
import nostr.event.filter.Filterable;
import nostr.event.impl.GenericEvent;

public class SinceFilter
extends AbstractFilterable<Long> {
    public static final String FILTER_KEY = "since";
    public static Function<JsonNode, List<Filterable>> fxn = node -> List.of(new SinceFilter(node.asLong()));

    public SinceFilter(Long since) {
        super(since, FILTER_KEY);
    }

    @Override
    public Predicate<GenericEvent> getPredicate() {
        return genericEvent -> genericEvent.getCreatedAt() > this.getSince();
    }

    @Override
    public ObjectNode toObjectNode(ObjectNode objectNode) {
        return IEvent.MAPPER_BLACKBIRD.createObjectNode().put(FILTER_KEY, this.getSince());
    }

    @Override
    public String getFilterableValue() {
        return this.getSince().toString();
    }

    private Long getSince() {
        return (Long)super.getFilterable();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SinceFilter)) {
            return false;
        }
        SinceFilter other = (SinceFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SinceFilter;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

