/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.Instant;
import java.util.List;
import lombok.Generated;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.NIP99Event;
import nostr.event.json.deserializer.ClassifiedListingEventDeserializer;
import nostr.event.tag.GenericTag;
import nostr.event.tag.PriceTag;

@Event(name="ClassifiedListingEvent", nip=99)
@JsonDeserialize(using=ClassifiedListingEventDeserializer.class)
public class ClassifiedListingEvent
extends NIP99Event {
    public ClassifiedListingEvent(PublicKey pubKey, Kind kind, List<BaseTag> tags, String content) {
        super(pubKey, kind, tags, content);
    }

    public Instant getPublishedAt() {
        BaseTag publishedAtTag = this.getTag("published_at");
        return Instant.ofEpochSecond(Long.parseLong(((GenericTag)publishedAtTag).getAttributes().get(0).value().toString()));
    }

    public String getLocation() {
        BaseTag locationTag = this.getTag("location");
        return ((GenericTag)locationTag).getAttributes().get(0).value().toString();
    }

    public String getTitle() {
        BaseTag titleTag = this.getTag("title");
        return ((GenericTag)titleTag).getAttributes().get(0).value().toString();
    }

    public String getSummary() {
        BaseTag summaryTag = this.getTag("summary");
        return ((GenericTag)summaryTag).getAttributes().get(0).value().toString();
    }

    public String getImage() {
        BaseTag imageTag = this.getTag("image");
        return ((GenericTag)imageTag).getAttributes().get(0).value().toString();
    }

    public Status getStatus() {
        BaseTag statusTag = this.getTag("status");
        String status = ((GenericTag)statusTag).getAttributes().get(0).value().toString();
        return Status.valueOf(status);
    }

    public String getPrice() {
        PriceTag priceTag = (PriceTag)this.getTags().stream().filter(tag -> tag instanceof PriceTag).findFirst().orElseThrow();
        return priceTag.getNumber().toString() + " " + priceTag.getCurrency() + (String)(priceTag.getFrequency() != null ? " " + priceTag.getFrequency() : "");
    }

    @Override
    protected void validateTags() {
        super.validateTags();
        BaseTag publishedAtTag = this.getTag("published_at");
        if (publishedAtTag == null) {
            throw new AssertionError((Object)"Missing `published_at` tag for the publication date/time.");
        }
        try {
            Long.parseLong(((GenericTag)publishedAtTag).getAttributes().get(0).value().toString());
        }
        catch (NumberFormatException e) {
            throw new AssertionError((Object)"Invalid `published_at` tag value: must be a numeric timestamp.");
        }
        if (this.getTag("location") == null) {
            throw new AssertionError((Object)"Missing `location` tag for the listing location.");
        }
        if (this.getTag("title") == null) {
            throw new AssertionError((Object)"Missing `title` tag for the listing title.");
        }
        if (this.getTag("summary") == null) {
            throw new AssertionError((Object)"Missing `summary` tag for the listing summary.");
        }
        if (this.getTag("image") == null) {
            throw new AssertionError((Object)"Missing `image` tag for the listing image.");
        }
        if (this.getTag("status") == null) {
            throw new AssertionError((Object)"Missing `status` tag for the listing status.");
        }
    }

    @Override
    public void validateKind() {
        Integer n = this.getKind();
        if (30402 <= n && n <= 30403) {
            return;
        }
        throw new AssertionError(String.format("Invalid kind value [%s]. Classified Listing must be either 30402 or 30403", n), null);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassifiedListingEvent)) {
            return false;
        }
        ClassifiedListingEvent other = (ClassifiedListingEvent)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClassifiedListingEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public ClassifiedListingEvent() {
    }

    public static enum Status {
        ACTIVE("active"),
        SOLD("sold");

        private final String value;

        private Status(String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
        }

        @Generated
        public String getValue() {
            return this.value;
        }
    }
}

