/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.beans.Transient;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Encoder;
import nostr.base.IEvent;
import nostr.base.ISignable;
import nostr.base.ITag;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.Signature;
import nostr.base.annotation.Key;
import nostr.crypto.bech32.Bech32;
import nostr.crypto.bech32.Bech32Prefix;
import nostr.event.BaseEvent;
import nostr.event.BaseTag;
import nostr.event.Deleteable;
import nostr.event.json.deserializer.PublicKeyDeserializer;
import nostr.event.json.deserializer.SignatureDeserializer;
import nostr.util.NostrException;
import nostr.util.NostrUtil;
import nostr.util.validator.HexStringValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericEvent
extends BaseEvent
implements ISignable,
Deleteable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericEvent.class);
    @Key
    private String id;
    @Key
    @JsonProperty(value="pubkey")
    @JsonDeserialize(using=PublicKeyDeserializer.class)
    private PublicKey pubKey;
    @Key
    @JsonProperty(value="created_at")
    private Long createdAt;
    @Key
    private Integer kind;
    @Key
    @JsonProperty(value="tags")
    private List<BaseTag> tags;
    @Key
    private String content;
    @Key
    @JsonProperty(value="sig")
    @JsonDeserialize(using=SignatureDeserializer.class)
    private Signature signature;
    @JsonIgnore
    private byte[] _serializedEvent;
    @JsonIgnore
    private Integer nip;

    public GenericEvent() {
        this.tags = new ArrayList<BaseTag>();
    }

    public GenericEvent(@NonNull String id) {
        this();
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.setId(id);
    }

    public GenericEvent(@NonNull PublicKey pubKey, @NonNull Kind kind) {
        this(pubKey, kind, new ArrayList<BaseTag>(), "");
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
    }

    public GenericEvent(@NonNull PublicKey pubKey, @NonNull Integer kind) {
        this(pubKey, kind, new ArrayList<BaseTag>(), "");
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
    }

    public GenericEvent(@NonNull PublicKey pubKey, @NonNull Kind kind, @NonNull List<BaseTag> tags) {
        this(pubKey, kind, tags, "");
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
    }

    public GenericEvent(@NonNull PublicKey pubKey, @NonNull Kind kind, @NonNull List<BaseTag> tags, @NonNull String content) {
        this(pubKey, kind.getValue(), tags, content);
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
    }

    public GenericEvent(@NonNull PublicKey pubKey, @NonNull Integer kind, @NonNull List<BaseTag> tags, @NonNull String content) {
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.pubKey = pubKey;
        this.kind = Kind.valueOf((int)kind).getValue();
        this.tags = new ArrayList<BaseTag>(tags);
        this.content = content;
        this.updateTagsParents(this.tags);
    }

    public void setId(String id) {
        HexStringValidator.validateHex((String)id, (int)64);
        this.id = id;
    }

    public String toBech32() {
        if (!this.isSigned()) {
            this.update();
        }
        try {
            return Bech32.toBech32((Bech32Prefix)Bech32Prefix.NOTE, (String)this.getId());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setTags(List<BaseTag> tags) {
        this.tags = new ArrayList<BaseTag>(tags);
        for (BaseTag tag : this.tags) {
            tag.setParent(this);
        }
    }

    public List<BaseTag> getTags() {
        return Collections.unmodifiableList(this.tags);
    }

    @Transient
    public boolean isReplaceable() {
        return this.kind != null && this.kind >= 10000 && this.kind < 20000;
    }

    @Transient
    public boolean isEphemeral() {
        return this.kind != null && this.kind >= 20000 && this.kind < 30000;
    }

    @Transient
    public boolean isAddressable() {
        return this.kind != null && this.kind >= 30000 && this.kind < 40000;
    }

    public void addTag(BaseTag tag) {
        if (tag == null) {
            return;
        }
        if (this.tags == null) {
            this.tags = new ArrayList<BaseTag>();
        }
        if (!this.tags.contains(tag)) {
            tag.setParent(this);
            this.tags.add(tag);
        }
    }

    public void update() {
        try {
            this.createdAt = Instant.now().getEpochSecond();
            this._serializedEvent = this.serialize().getBytes(StandardCharsets.UTF_8);
            this.id = NostrUtil.bytesToHex((byte[])NostrUtil.sha256((byte[])this._serializedEvent));
        }
        catch (NoSuchAlgorithmException | NostrException ex) {
            throw new RuntimeException(ex);
        }
        catch (AssertionError ex) {
            log.warn(((Throwable)((Object)ex)).getMessage());
            throw new RuntimeException((Throwable)((Object)ex));
        }
    }

    @Transient
    public boolean isSigned() {
        return this.signature != null;
    }

    public void validate() {
        Objects.requireNonNull(this.id, "Missing required `id` field.");
        HexStringValidator.validateHex((String)this.id, (int)64);
        Objects.requireNonNull(this.pubKey, "Missing required `pubkey` field.");
        HexStringValidator.validateHex((String)this.pubKey.toString(), (int)64);
        Objects.requireNonNull(this.signature, "Missing required `sig` field.");
        HexStringValidator.validateHex((String)this.signature.toString(), (int)128);
        if (this.createdAt == null || this.createdAt < 0L) {
            throw new AssertionError((Object)"Invalid `created_at`: Must be a non-negative integer.");
        }
        this.validateKind();
        this.validateTags();
        this.validateContent();
    }

    protected void validateKind() {
        if (this.kind == null || this.kind < 0) {
            throw new AssertionError((Object)"Invalid `kind`: Must be a non-negative integer.");
        }
    }

    protected void validateTags() {
        if (this.tags == null) {
            throw new AssertionError((Object)"Invalid `tags`: Must be a non-null array.");
        }
    }

    protected void validateContent() {
        if (this.content == null) {
            throw new AssertionError((Object)"Invalid `content`: Must be a string.");
        }
    }

    private String serialize() throws NostrException {
        ObjectMapper mapper = Encoder.ENCODER_MAPPER_BLACKBIRD;
        ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
        try {
            arrayNode.add(0);
            arrayNode.add(this.pubKey.toString());
            arrayNode.add(this.createdAt);
            arrayNode.add(this.kind);
            arrayNode.add(mapper.valueToTree(this.tags));
            arrayNode.add(this.content);
            return mapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new NostrException(e.getMessage());
        }
    }

    @Transient
    public Consumer<Signature> getSignatureConsumer() {
        return this::setSignature;
    }

    @Transient
    public Supplier<ByteBuffer> getByteArraySupplier() {
        this.update();
        log.debug("Serialized event: {}", (Object)new String(this.get_serializedEvent()));
        return () -> ByteBuffer.wrap(this.get_serializedEvent());
    }

    protected final void updateTagsParents(List<? extends BaseTag> tagList) {
        if (tagList != null && !tagList.isEmpty()) {
            for (ITag iTag : tagList) {
                iTag.setParent((IEvent)this);
            }
        }
    }

    protected <T extends BaseTag> void addStandardTag(List<T> tag) {
        Optional.ofNullable(tag).ifPresent(tagList -> tagList.forEach(this::addStandardTag));
    }

    protected void addStandardTag(BaseTag tag) {
        Optional.ofNullable(tag).ifPresent(this::addTag);
    }

    protected void addGenericTag(String key, Integer nip, Object value) {
        Optional.ofNullable(value).ifPresent(s -> this.addTag(BaseTag.create(key, s.toString())));
    }

    protected void addStringListTag(String label, Integer nip, List<String> tag) {
        Optional.ofNullable(tag).ifPresent(tagList -> BaseTag.create(label, tagList));
    }

    protected BaseTag getTag(@NonNull String code) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        return this.getTags().stream().filter(tag -> code.equals(tag.getCode())).findFirst().orElseThrow();
    }

    protected List<BaseTag> getTags(@NonNull String code) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        return this.getTags().stream().filter(tag -> code.equals(tag.getCode())).toList();
    }

    protected BaseTag requireTag(@NonNull String code) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        return this.getTags().stream().filter(tag -> code.equals(tag.getCode())).findFirst().orElseThrow(() -> new AssertionError((Object)("Missing required `" + code + "` tag.")));
    }

    protected <T extends BaseTag> T requireTagInstance(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        return (T)this.getTags().stream().filter(clazz::isInstance).map(clazz::cast).findFirst().orElseThrow(() -> new AssertionError((Object)("Missing required `" + clazz.getSimpleName() + "` tag.")));
    }

    public static <T extends GenericEvent> T convert(@NonNull GenericEvent genericEvent, @NonNull Class<T> clazz) throws NostrException {
        if (genericEvent == null) {
            throw new NullPointerException("genericEvent is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        try {
            GenericEvent event = (GenericEvent)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            event.setContent(genericEvent.getContent());
            event.setTags(genericEvent.getTags());
            event.setPubKey(genericEvent.getPubKey());
            event.setId(genericEvent.getId());
            event.set_serializedEvent(genericEvent.get_serializedEvent());
            event.setNip(genericEvent.getNip());
            event.setKind(genericEvent.getKind());
            event.setSignature(genericEvent.getSignature());
            event.setCreatedAt(genericEvent.getCreatedAt());
            return (T)event;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new NostrException("Failed to convert GenericEvent", (Throwable)e);
        }
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public PublicKey getPubKey() {
        return this.pubKey;
    }

    @Generated
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Generated
    public Integer getKind() {
        return this.kind;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public Signature getSignature() {
        return this.signature;
    }

    @Generated
    public byte[] get_serializedEvent() {
        return this._serializedEvent;
    }

    @Generated
    public Integer getNip() {
        return this.nip;
    }

    @JsonProperty(value="pubkey")
    @JsonDeserialize(using=PublicKeyDeserializer.class)
    @Generated
    public void setPubKey(PublicKey pubKey) {
        this.pubKey = pubKey;
    }

    @JsonProperty(value="created_at")
    @Generated
    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setKind(Integer kind) {
        this.kind = kind;
    }

    @Generated
    public void setContent(String content) {
        this.content = content;
    }

    @JsonProperty(value="sig")
    @JsonDeserialize(using=SignatureDeserializer.class)
    @Generated
    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    @JsonIgnore
    @Generated
    public void set_serializedEvent(byte[] _serializedEvent) {
        this._serializedEvent = _serializedEvent;
    }

    @JsonIgnore
    @Generated
    public void setNip(Integer nip) {
        this.nip = nip;
    }

    @Generated
    public String toString() {
        return "GenericEvent(id=" + this.getId() + ", pubKey=" + String.valueOf(this.getPubKey()) + ", createdAt=" + this.getCreatedAt() + ", kind=" + this.getKind() + ", tags=" + String.valueOf(this.getTags()) + ", content=" + this.getContent() + ", signature=" + String.valueOf(this.getSignature()) + ", _serializedEvent=" + Arrays.toString(this.get_serializedEvent()) + ", nip=" + this.getNip() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericEvent)) {
            return false;
        }
        GenericEvent other = (GenericEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        PublicKey this$pubKey = this.getPubKey();
        PublicKey other$pubKey = other.getPubKey();
        return !(this$pubKey == null ? other$pubKey != null : !this$pubKey.equals(other$pubKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GenericEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        PublicKey $pubKey = this.getPubKey();
        result = result * 59 + ($pubKey == null ? 43 : $pubKey.hashCode());
        return result;
    }
}

