/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import lombok.Generated;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.event.BaseTag;
import nostr.event.entities.NIP15Content;
import nostr.event.impl.AddressableEvent;
import nostr.event.tag.GenericTag;

public abstract class MerchantEvent<T extends NIP15Content.MerchantContent>
extends AddressableEvent {
    public MerchantEvent(PublicKey sender, Kind kind, List<BaseTag> tags, String content) {
        this(sender, kind.getValue(), tags, content);
    }

    public MerchantEvent(PublicKey sender, Integer kind, List<BaseTag> tags, String content) {
        super(sender, kind, tags, content);
    }

    protected abstract T getEntity();

    @Override
    protected void validateTags() {
        String entityId;
        super.validateTags();
        BaseTag dTag = this.getTag("d");
        if (dTag == null) {
            throw new AssertionError((Object)"Missing `d` tag.");
        }
        String id = ((GenericTag)dTag).getAttributes().getFirst().value().toString();
        if (!id.equals(entityId = ((NIP15Content)this.getEntity()).getId())) {
            throw new AssertionError((Object)"The d-tag value MUST be the same as the stall id.");
        }
    }

    @Override
    protected void validateContent() {
        super.validateContent();
        try {
            T entity = this.getEntity();
            if (entity == null) {
                throw new AssertionError((Object)"Invalid `content`: Unable to parse merchant entity.");
            }
            if (((NIP15Content)entity).getId() == null || ((NIP15Content)entity).getId().isEmpty()) {
                throw new AssertionError((Object)"Invalid `content`: `id` field is required.");
            }
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionError("Invalid `content`: Must be a valid JSON object.", e);
        }
    }

    @Override
    @Generated
    public String toString() {
        return "MerchantEvent()";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MerchantEvent)) {
            return false;
        }
        MerchantEvent other = (MerchantEvent)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MerchantEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public MerchantEvent() {
    }
}

