/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.entities.ZapReceipt;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.GenericTag;
import nostr.event.tag.PubKeyTag;

@Event(name="ZapReceiptEvent", nip=57)
public class ZapReceiptEvent
extends GenericEvent {
    public ZapReceiptEvent(@NonNull PublicKey recipientPubKey, @NonNull List<BaseTag> tags, @NonNull String content) {
        super(recipientPubKey, Kind.ZAP_RECEIPT, tags, content);
        if (recipientPubKey == null) {
            throw new NullPointerException("recipientPubKey is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
    }

    public ZapReceipt getZapReceipt() {
        BaseTag preimageTag = this.requireTag("preimage");
        BaseTag descriptionTag = this.requireTag("description");
        BaseTag bolt11Tag = this.requireTag("bolt11");
        return new ZapReceipt(((GenericTag)bolt11Tag).getAttributes().get(0).value().toString(), ((GenericTag)descriptionTag).getAttributes().get(0).value().toString(), ((GenericTag)preimageTag).getAttributes().get(0).value().toString());
    }

    public String getBolt11() {
        ZapReceipt zapReceipt = this.getZapReceipt();
        return zapReceipt.getBolt11();
    }

    public String getDescriptionSha256() {
        ZapReceipt zapReceipt = this.getZapReceipt();
        return zapReceipt.getDescriptionSha256();
    }

    public String getPreimage() {
        ZapReceipt zapReceipt = this.getZapReceipt();
        return zapReceipt.getPreimage();
    }

    public PublicKey getRecipient() {
        PubKeyTag recipientPubKeyTag = (PubKeyTag)this.requireTag("p");
        return recipientPubKeyTag.getPublicKey();
    }

    public PublicKey getSender() {
        BaseTag senderTag = this.getTag("P");
        if (senderTag == null) {
            return null;
        }
        PubKeyTag senderPubKeyTag = (PubKeyTag)senderTag;
        return senderPubKeyTag.getPublicKey();
    }

    public String getEventId() {
        BaseTag eventTag = this.getTag("e");
        if (eventTag == null) {
            return null;
        }
        return ((GenericTag)eventTag).getAttributes().get(0).value().toString();
    }

    @Override
    protected void validateTags() {
        super.validateTags();
        this.requireTag("p");
        this.requireTag("bolt11");
        this.requireTag("description");
        this.requireTag("preimage");
    }

    @Override
    protected void validateKind() {
        if (this.getKind().intValue() != Kind.ZAP_RECEIPT.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.ZAP_RECEIPT.getValue()));
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZapReceiptEvent)) {
            return false;
        }
        ZapReceiptEvent other = (ZapReceiptEvent)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ZapReceiptEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public ZapReceiptEvent() {
    }
}

