/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.entities.ZapRequest;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.GenericTag;
import nostr.event.tag.PubKeyTag;
import nostr.event.tag.RelaysTag;

@Event(name="ZapRequestEvent", nip=57)
public class ZapRequestEvent
extends GenericEvent {
    public ZapRequestEvent(@NonNull PublicKey recipientPubKey, @NonNull List<BaseTag> tags, @NonNull String content) {
        super(recipientPubKey, Kind.ZAP_REQUEST, tags, content);
        if (recipientPubKey == null) {
            throw new NullPointerException("recipientPubKey is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
    }

    public ZapRequest getZapRequest() {
        BaseTag relaysTag = this.getTag("relays");
        BaseTag amountTag = this.getTag("amount");
        BaseTag lnUrlTag = this.getTag("lnurl");
        return new ZapRequest((RelaysTag)relaysTag, Long.parseLong(((GenericTag)amountTag).getAttributes().get(0).value().toString()), ((GenericTag)lnUrlTag).getAttributes().get(0).value().toString());
    }

    public PublicKey getRecipientKey() {
        return this.getTags().stream().filter(tag -> "p".equals(tag.getCode())).map(tag -> ((PubKeyTag)tag).getPublicKey()).findFirst().orElseThrow(() -> new IllegalArgumentException("Recipient public key not found in tags"));
    }

    public String getEventId() {
        return this.getTags().stream().filter(tag -> "e".equals(tag.getCode())).map(tag -> ((GenericTag)tag).getAttributes().get(0).value().toString()).findFirst().orElse(null);
    }

    public List<Relay> getRelays() {
        ZapRequest zapRequest = this.getZapRequest();
        return zapRequest.getRelaysTag() != null ? zapRequest.getRelaysTag().getRelays() : null;
    }

    public String getLnUrl() {
        ZapRequest zapRequest = this.getZapRequest();
        return zapRequest.getLnUrl();
    }

    public Long getAmount() {
        ZapRequest zapRequest = this.getZapRequest();
        return zapRequest.getAmount();
    }

    @Override
    protected void validateTags() {
        super.validateTags();
        boolean hasRecipientTag = this.getTags().stream().anyMatch(tag -> "p".equals(tag.getCode()));
        if (!hasRecipientTag) {
            throw new AssertionError((Object)"Invalid `tags`: Must include a `p` tag for the recipient's public key.");
        }
        boolean hasAmountTag = this.getTags().stream().anyMatch(tag -> "amount".equals(tag.getCode()));
        if (!hasAmountTag) {
            throw new AssertionError((Object)"Invalid `tags`: Must include an `amount` tag specifying the amount in millisatoshis.");
        }
        boolean hasLnUrlTag = this.getTags().stream().anyMatch(tag -> "lnurl".equals(tag.getCode()));
        if (!hasLnUrlTag) {
            throw new AssertionError((Object)"Invalid `tags`: Must include an `lnurl` tag containing the Lightning Network URL.");
        }
    }

    @Override
    protected void validateKind() {
        if (this.getKind().intValue() != Kind.ZAP_REQUEST.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.ZAP_REQUEST.getValue()));
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZapRequestEvent)) {
            return false;
        }
        ZapRequestEvent other = (ZapRequestEvent)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ZapRequestEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public ZapRequestEvent() {
    }
}

