/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.json.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.IDecoder;
import nostr.event.BaseMessage;
import nostr.event.json.codec.EventEncodingException;
import nostr.event.message.CanonicalAuthenticationMessage;
import nostr.event.message.CloseMessage;
import nostr.event.message.EoseMessage;
import nostr.event.message.EventMessage;
import nostr.event.message.NoticeMessage;
import nostr.event.message.OkMessage;
import nostr.event.message.RelayAuthenticationMessage;
import nostr.event.message.ReqMessage;

public class BaseMessageDecoder<T extends BaseMessage>
implements IDecoder<T> {
    public static final int COMMAND_INDEX = 0;
    public static final int ARG_INDEX = 1;

    public T decode(@NonNull String jsonString) throws EventEncodingException {
        if (jsonString == null) {
            throw new NullPointerException("jsonString is marked non-null but is null");
        }
        ValidNostrJsonStructure validNostrJsonStructure = this.validateProperlyFormedJson(jsonString);
        String command = validNostrJsonStructure.getCommand();
        Object subscriptionId = validNostrJsonStructure.getSubscriptionId();
        return (T)(switch (command) {
            case "AUTH" -> {
                Object v0;
                if (subscriptionId instanceof Map) {
                    Map map = (Map)subscriptionId;
                    v0 = CanonicalAuthenticationMessage.decode(map);
                } else {
                    v0 = RelayAuthenticationMessage.decode(subscriptionId);
                }
                yield (BaseMessage)v0;
            }
            case "EVENT" -> (BaseMessage)EventMessage.decode(jsonString);
            case "CLOSE" -> (BaseMessage)CloseMessage.decode(subscriptionId);
            case "REQ" -> (BaseMessage)ReqMessage.decode(subscriptionId, jsonString);
            case "EOSE" -> (BaseMessage)EoseMessage.decode(subscriptionId);
            case "NOTICE" -> (BaseMessage)NoticeMessage.decode(subscriptionId);
            case "OK" -> (BaseMessage)OkMessage.decode(jsonString);
            default -> throw new IllegalArgumentException(String.format("Invalid JSON command [%s] in JSON string [%s] ", command, jsonString));
        });
    }

    private ValidNostrJsonStructure validateProperlyFormedJson(@NonNull String jsonString) throws EventEncodingException {
        if (jsonString == null) {
            throw new NullPointerException("jsonString is marked non-null but is null");
        }
        try {
            JsonNode root = I_DECODER_MAPPER_BLACKBIRD.readTree(jsonString);
            JsonNode commandNode = root.get(0);
            JsonNode argNode = root.get(1);
            if (commandNode == null || argNode == null) {
                String missingFields = (commandNode == null ? "commandNode" : "") + (commandNode == null && argNode == null ? " and " : "") + (argNode == null ? "argNode" : "");
                throw new IllegalArgumentException(String.format("Invalid JSON structure: Missing %s in JSON string [%s]", missingFields, jsonString));
            }
            return new ValidNostrJsonStructure(commandNode.asText(), argNode.asText());
        }
        catch (JsonProcessingException e) {
            throw new EventEncodingException("Failed to decode message", (Throwable)e);
        }
    }

    @Generated
    public BaseMessageDecoder() {
    }

    private record ValidNostrJsonStructure(@NonNull String getCommand, @NonNull Object getSubscriptionId) {
        @Generated
        public ValidNostrJsonStructure(@NonNull String getCommand, @NonNull Object getSubscriptionId) {
            if (getCommand == null) {
                throw new NullPointerException("getCommand is marked non-null but is null");
            }
            if (getSubscriptionId == null) {
                throw new NullPointerException("getSubscriptionId is marked non-null but is null");
            }
        }
    }
}

