/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Command;
import nostr.base.Encoder;
import nostr.base.IDecoder;
import nostr.event.BaseMessage;
import nostr.event.json.codec.EventEncodingException;

public class OkMessage
extends BaseMessage {
    @JsonProperty
    private final String eventId;
    @JsonProperty
    private final Boolean flag;
    @JsonProperty
    private final String message;

    public OkMessage(String eventId, Boolean flag, String message) {
        super(Command.OK.name());
        this.eventId = eventId;
        this.flag = flag;
        this.message = message;
    }

    @Override
    public String encode() throws EventEncodingException {
        try {
            return Encoder.ENCODER_MAPPER_BLACKBIRD.writeValueAsString((Object)JsonNodeFactory.instance.arrayNode().add(this.getCommand()).add(this.getEventId()).add(this.getFlag()).add(this.getMessage()));
        }
        catch (JsonProcessingException e) {
            throw new EventEncodingException("Failed to encode ok message", (Throwable)e);
        }
    }

    public static <T extends BaseMessage> T decode(@NonNull String jsonString) throws EventEncodingException {
        if (jsonString == null) {
            throw new NullPointerException("jsonString is marked non-null but is null");
        }
        try {
            Object[] msgArr = (Object[])IDecoder.I_DECODER_MAPPER_BLACKBIRD.readValue(jsonString, Object[].class);
            return (T)new OkMessage(msgArr[1].toString(), (Boolean)msgArr[2], msgArr[3].toString());
        }
        catch (JsonProcessingException e) {
            throw new EventEncodingException("Failed to decode ok message", (Throwable)e);
        }
    }

    @Generated
    public String getEventId() {
        return this.eventId;
    }

    @Generated
    public Boolean getFlag() {
        return this.flag;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }
}

