/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.tag;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Marker;
import nostr.base.annotation.Key;
import nostr.base.annotation.Tag;
import nostr.event.BaseTag;
import nostr.event.tag.GenericTag;

@Tag(code="e", name="event")
@JsonPropertyOrder(value={"idEvent", "recommendedRelayUrl", "marker"})
public class EventTag
extends BaseTag {
    @Key
    @JsonProperty
    private String idEvent;
    @Key
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String recommendedRelayUrl;
    @Key(nip=10)
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Marker marker;

    public EventTag(String idEvent) {
        this.idEvent = idEvent;
    }

    public static <T extends BaseTag> T deserialize(@NonNull JsonNode node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        EventTag tag = new EventTag();
        EventTag.setRequiredField(node.get(1), (n, t) -> tag.setIdEvent(n.asText()), tag);
        EventTag.setOptionalField(node.get(2), (n, t) -> tag.setRecommendedRelayUrl(n.asText()), tag);
        EventTag.setOptionalField(node.get(3), (n, t) -> tag.setMarker(Marker.valueOf((String)n.asText().toUpperCase())), tag);
        return (T)tag;
    }

    public static EventTag updateFields(@NonNull GenericTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (!"e".equals(tag.getCode())) {
            throw new IllegalArgumentException("Invalid tag code for EventTag");
        }
        EventTag eventTag = new EventTag(tag.getAttributes().get(0).value().toString());
        if (tag.getAttributes().size() > 1) {
            eventTag.setRecommendedRelayUrl(tag.getAttributes().get(1).value().toString());
        }
        if (tag.getAttributes().size() > 2) {
            eventTag.setMarker(Marker.valueOf((String)tag.getAttributes().get(2).value().toString()));
        }
        return eventTag;
    }

    @Generated
    public static EventTagBuilder builder() {
        return new EventTagBuilder();
    }

    @Generated
    public String getIdEvent() {
        return this.idEvent;
    }

    @Generated
    public String getRecommendedRelayUrl() {
        return this.recommendedRelayUrl;
    }

    @Generated
    public Marker getMarker() {
        return this.marker;
    }

    @JsonProperty
    @Generated
    public void setIdEvent(String idEvent) {
        this.idEvent = idEvent;
    }

    @JsonProperty
    @Generated
    public void setRecommendedRelayUrl(String recommendedRelayUrl) {
        this.recommendedRelayUrl = recommendedRelayUrl;
    }

    @JsonProperty
    @Generated
    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    @Override
    @Generated
    public String toString() {
        return "EventTag(idEvent=" + this.getIdEvent() + ", recommendedRelayUrl=" + this.getRecommendedRelayUrl() + ", marker=" + String.valueOf(this.getMarker()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventTag)) {
            return false;
        }
        EventTag other = (EventTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$idEvent = this.getIdEvent();
        String other$idEvent = other.getIdEvent();
        if (this$idEvent == null ? other$idEvent != null : !this$idEvent.equals(other$idEvent)) {
            return false;
        }
        String this$recommendedRelayUrl = this.getRecommendedRelayUrl();
        String other$recommendedRelayUrl = other.getRecommendedRelayUrl();
        if (this$recommendedRelayUrl == null ? other$recommendedRelayUrl != null : !this$recommendedRelayUrl.equals(other$recommendedRelayUrl)) {
            return false;
        }
        Marker this$marker = this.getMarker();
        Marker other$marker = other.getMarker();
        return !(this$marker == null ? other$marker != null : !this$marker.equals(other$marker));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventTag;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $idEvent = this.getIdEvent();
        result = result * 59 + ($idEvent == null ? 43 : $idEvent.hashCode());
        String $recommendedRelayUrl = this.getRecommendedRelayUrl();
        result = result * 59 + ($recommendedRelayUrl == null ? 43 : $recommendedRelayUrl.hashCode());
        Marker $marker = this.getMarker();
        result = result * 59 + ($marker == null ? 43 : $marker.hashCode());
        return result;
    }

    @Generated
    public EventTag() {
    }

    @Generated
    public EventTag(String idEvent, String recommendedRelayUrl, Marker marker) {
        this.idEvent = idEvent;
        this.recommendedRelayUrl = recommendedRelayUrl;
        this.marker = marker;
    }

    @Generated
    public static class EventTagBuilder {
        @Generated
        private String idEvent;
        @Generated
        private String recommendedRelayUrl;
        @Generated
        private Marker marker;

        @Generated
        EventTagBuilder() {
        }

        @JsonProperty
        @Generated
        public EventTagBuilder idEvent(String idEvent) {
            this.idEvent = idEvent;
            return this;
        }

        @JsonProperty
        @Generated
        public EventTagBuilder recommendedRelayUrl(String recommendedRelayUrl) {
            this.recommendedRelayUrl = recommendedRelayUrl;
            return this;
        }

        @JsonProperty
        @Generated
        public EventTagBuilder marker(Marker marker) {
            this.marker = marker;
            return this;
        }

        @Generated
        public EventTag build() {
            return new EventTag(this.idEvent, this.recommendedRelayUrl, this.marker);
        }

        @Generated
        public String toString() {
            return "EventTag.EventTagBuilder(idEvent=" + this.idEvent + ", recommendedRelayUrl=" + this.recommendedRelayUrl + ", marker=" + String.valueOf(this.marker) + ")";
        }
    }
}

