/*
 * Decompiled with CFR 0.152.
 */
package nostr.event;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.ElementAttribute;
import nostr.base.IEvent;
import nostr.base.ITag;
import nostr.base.annotation.Key;
import nostr.base.annotation.Tag;
import nostr.event.json.deserializer.TagDeserializer;
import nostr.event.json.serializer.BaseTagSerializer;
import nostr.event.tag.GenericTag;
import nostr.event.tag.TagRegistry;
import org.apache.commons.lang3.stream.Streams;

@JsonDeserialize(using=TagDeserializer.class)
@JsonSerialize(using=BaseTagSerializer.class)
public abstract class BaseTag
implements ITag {
    @JsonIgnore
    private IEvent parent;

    public void setParent(IEvent event) {
        this.parent = event;
    }

    public String getCode() {
        return this.getClass().getAnnotation(Tag.class).code();
    }

    public Optional<String> getFieldValue(Field field) {
        try {
            return Optional.ofNullable(new PropertyDescriptor(field.getName(), this.getClass()).getReadMethod().invoke((Object)this, new Object[0])).map(Object::toString);
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            return Optional.empty();
        }
    }

    public List<Field> getSupportedFields() {
        return (List)Streams.failableStream(Arrays.stream(this.getClass().getDeclaredFields())).filter(f -> Objects.nonNull(f.getAnnotation(Key.class))).filter(f -> this.getFieldValue((Field)f).isPresent()).collect(Collectors.toList());
    }

    public static BaseTag create(String code, Integer nip, String ... params) {
        return BaseTag.create(code, List.of(params));
    }

    @Deprecated(forRemoval=true)
    public static BaseTag create(String code, Integer nip, List<String> params) {
        return BaseTag.create(code, params);
    }

    public static BaseTag create(@NonNull String code, String ... params) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return BaseTag.create(code, List.of(params));
    }

    public static BaseTag create(@NonNull String code, @NonNull List<String> params) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        GenericTag genericTag = new GenericTag(code, IntStream.range(0, params.size()).mapToObj(i -> new ElementAttribute("param".concat(String.valueOf(i)), params.get(i))).toList());
        return Optional.ofNullable(TagRegistry.get(code)).map(f -> (BaseTag)f.apply(genericTag)).orElse(genericTag);
    }

    protected static <T extends BaseTag> void setOptionalField(JsonNode node, BiConsumer<JsonNode, T> con, T tag) {
        Optional.ofNullable(node).ifPresent(n -> con.accept((JsonNode)n, tag));
    }

    protected static <T extends BaseTag> void setRequiredField(JsonNode node, BiConsumer<JsonNode, T> con, T tag) {
        con.accept(Optional.ofNullable(node).orElseThrow(), (JsonNode)tag);
    }

    @Generated
    public BaseTag() {
    }

    @Generated
    public IEvent getParent() {
        return this.parent;
    }

    @Generated
    public String toString() {
        return "BaseTag(parent=" + String.valueOf(this.getParent()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseTag)) {
            return false;
        }
        BaseTag other = (BaseTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IEvent this$parent = this.getParent();
        IEvent other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseTag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IEvent $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        return result;
    }
}

