/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import lombok.Generated;
import nostr.base.Kind;
import nostr.base.Marker;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.entities.ChannelProfile;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.EventTag;
import nostr.event.tag.HashtagTag;

@Event(name="Channel Metadata", nip=28)
public class ChannelMetadataEvent
extends GenericEvent {
    public ChannelMetadataEvent(PublicKey pubKey, List<BaseTag> baseTagList, String content) {
        super(pubKey, Kind.CHANNEL_METADATA, baseTagList, content);
    }

    public ChannelProfile getChannelProfile() {
        String content = this.getContent();
        return (ChannelProfile)MAPPER_BLACKBIRD.readValue(content, ChannelProfile.class);
    }

    @Override
    protected void validateContent() {
        super.validateContent();
        try {
            ChannelProfile profile = this.getChannelProfile();
            if (profile.getName() == null || profile.getName().isEmpty()) {
                throw new AssertionError((Object)"Invalid `content`: `name` field is required.");
            }
            if (profile.getAbout() == null || profile.getAbout().isEmpty()) {
                throw new AssertionError((Object)"Invalid `content`: `about` field is required.");
            }
            if (profile.getPicture() == null) {
                throw new AssertionError((Object)"Invalid `content`: `picture` field is required.");
            }
        }
        catch (Exception e) {
            throw new AssertionError("Invalid `content`: Must be a valid ChannelProfile JSON object.", e);
        }
    }

    public String getChannelCreateEventId() {
        return this.getTags().stream().filter(tag -> "e".equals(tag.getCode())).map(tag -> (EventTag)tag).filter(tag -> tag.getMarker() == Marker.ROOT).map(EventTag::getIdEvent).findFirst().orElseThrow();
    }

    public List<String> getCategories() {
        return this.getTags().stream().filter(tag -> "t".equals(tag.getCode())).map(tag -> (HashtagTag)tag).map(HashtagTag::getHashTag).toList();
    }

    @Override
    protected void validateTags() {
        super.validateTags();
        EventTag rootTag = this.getTags().stream().filter(tag -> "e".equals(tag.getCode())).map(tag -> (EventTag)tag).filter(tag -> tag.getMarker() == Marker.ROOT).findFirst().orElseThrow(() -> new AssertionError((Object)"Missing or invalid `e` root tag."));
    }

    @Override
    protected void validateKind() {
        if (this.getKind().intValue() != Kind.CHANNEL_METADATA.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.CHANNEL_METADATA.getValue()));
        }
    }

    @Generated
    public ChannelMetadataEvent() {
    }
}

