/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.IEvent;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.entities.Stall;
import nostr.event.impl.MerchantEvent;

@Event(name="Create or update a stall", nip=15)
public class CreateOrUpdateStallEvent
extends MerchantEvent<Stall> {
    public CreateOrUpdateStallEvent(@NonNull PublicKey sender, @NonNull List<BaseTag> tags, @NonNull String content) {
        super(sender, Kind.STALL_CREATE_OR_UPDATE.getValue(), tags, content);
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
    }

    public Stall getStall() {
        return (Stall)IEvent.MAPPER_BLACKBIRD.readValue(this.getContent(), Stall.class);
    }

    @Override
    protected Stall getEntity() {
        return this.getStall();
    }

    @Override
    public void validateKind() {
        if (this.getKind().intValue() != Kind.STALL_CREATE_OR_UPDATE.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.STALL_CREATE_OR_UPDATE.getValue()));
        }
    }

    @Override
    protected void validateContent() {
        super.validateContent();
        try {
            Stall stall = this.getStall();
            if (stall.getName() == null || stall.getName().isEmpty()) {
                throw new AssertionError((Object)"Invalid `content`: `name` field is required.");
            }
            if (stall.getCurrency() == null || stall.getCurrency().isEmpty()) {
                throw new AssertionError((Object)"Invalid `content`: `currency` field is required.");
            }
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionError("Invalid `content`: Must be a valid Stall JSON object.", e);
        }
    }

    @Override
    @Generated
    public String toString() {
        return "CreateOrUpdateStallEvent()";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateOrUpdateStallEvent)) {
            return false;
        }
        CreateOrUpdateStallEvent other = (CreateOrUpdateStallEvent)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateOrUpdateStallEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public CreateOrUpdateStallEvent() {
    }
}

