/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.PubKeyTag;

@Event(name="Handling Mentions", nip=8)
public final class MentionsEvent
extends GenericEvent {
    public MentionsEvent(PublicKey pubKey, Integer kind, List<BaseTag> tags, String content) {
        super(pubKey, kind, tags, content);
    }

    @Override
    public void update() {
        AtomicInteger counter = new AtomicInteger(0);
        this.getTags().forEach(tag -> {
            String replacement = "#[" + counter.getAndIncrement() + "]";
            this.setContent(this.getContent().replace(((PubKeyTag)tag).getPublicKey().toString(), replacement));
        });
        super.update();
    }

    @Override
    protected void validateTags() {
        super.validateTags();
        boolean hasValidPubKeyTag = this.getTags().stream().anyMatch(tag -> tag instanceof PubKeyTag);
        if (!hasValidPubKeyTag) {
            throw new AssertionError((Object)"Invalid `tags`: Must include at least one valid PubKeyTag.");
        }
    }

    @Override
    @Generated
    public String toString() {
        return "MentionsEvent()";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MentionsEvent)) {
            return false;
        }
        MentionsEvent other = (MentionsEvent)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MentionsEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public MentionsEvent() {
    }
}

