/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import lombok.Generated;
import nostr.base.IEvent;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.entities.CashuMint;
import nostr.event.entities.CashuProof;
import nostr.event.entities.NutZap;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.EventTag;
import nostr.event.tag.GenericTag;
import nostr.event.tag.PubKeyTag;

@Event(name="Nut Zap Event", nip=61)
public class NutZapEvent
extends GenericEvent {
    public NutZapEvent(PublicKey sender, List<BaseTag> tags, String content) {
        super(sender, Kind.NUTZAP, tags, content);
    }

    public NutZap getNutZap() {
        NutZap nutZap = new NutZap();
        EventTag zappedEvent = this.getTags().stream().filter(tag -> tag instanceof EventTag).map(tag -> (EventTag)tag).findFirst().orElse(null);
        List<GenericTag> proofs = this.getTags().stream().filter(tag -> "proof".equals(tag.getCode())).map(tag -> (GenericTag)tag).toList();
        PubKeyTag recipientTag = this.getTags().stream().filter(tag -> tag instanceof PubKeyTag).map(tag -> (PubKeyTag)tag).findFirst().orElseThrow(() -> new IllegalStateException("No PubKeyTag found in tags"));
        GenericTag mintTag = this.getTags().stream().filter(tag -> "u".equals(tag.getCode())).map(tag -> (GenericTag)tag).findFirst().orElseThrow(() -> new IllegalStateException("No mint tag found in tags"));
        nutZap.setMint(this.getMintFromTag(mintTag));
        proofs.forEach(proofTag -> {
            CashuProof cashuProof = this.getProofFromTag((GenericTag)proofTag);
            nutZap.addProof(cashuProof);
        });
        nutZap.setRecipient(recipientTag.getPublicKey());
        nutZap.setNutZappedEvent(zappedEvent);
        return nutZap;
    }

    @Override
    protected void validateTags() {
        super.validateTags();
        boolean hasMintTag = this.getTags().stream().anyMatch(tag -> "u".equals(tag.getCode()));
        if (!hasMintTag) {
            throw new AssertionError((Object)"Invalid `tags`: Must include a mint tag with code 'u'.");
        }
        boolean hasValidPubKeyTag = this.getTags().stream().anyMatch(tag -> tag instanceof PubKeyTag);
        if (!hasValidPubKeyTag) {
            throw new AssertionError((Object)"Invalid `tags`: Must include one valid PubKeyTag.");
        }
        boolean hasProofTag = this.getTags().stream().anyMatch(tag -> "proof".equals(tag.getCode()));
        if (!hasProofTag) {
            throw new AssertionError((Object)"Invalid `tags`: Must include at least one Proof tag with code 'proof'.");
        }
    }

    @Override
    protected void validateKind() {
        if (this.getKind().intValue() != Kind.NUTZAP.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.NUTZAP.getValue()));
        }
    }

    private CashuMint getMintFromTag(GenericTag mintTag) {
        String url = mintTag.getAttributes().get(0).value().toString();
        CashuMint mint = new CashuMint(url);
        return mint;
    }

    private CashuProof getProofFromTag(GenericTag proofTag) {
        String proof = proofTag.getAttributes().get(0).value().toString();
        CashuProof cashuProof = (CashuProof)IEvent.MAPPER_BLACKBIRD.convertValue((Object)proof, CashuProof.class);
        return cashuProof;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NutZapEvent)) {
            return false;
        }
        NutZapEvent other = (NutZapEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NutZapEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "NutZapEvent()";
    }
}

