/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.NIP01Event;
import nostr.event.tag.PubKeyTag;

@Event(name="Text Note")
public class TextNoteEvent
extends NIP01Event {
    public TextNoteEvent(@NonNull PublicKey pubKey, @NonNull List<BaseTag> tags, @NonNull String content) {
        super(pubKey, Kind.TEXT_NOTE, tags, content);
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
    }

    public List<PubKeyTag> getRecipientPubkeyTags() {
        return this.getTags().stream().filter(tag -> tag instanceof PubKeyTag).map(tag -> (PubKeyTag)tag).toList();
    }

    public List<PublicKey> getRecipients() {
        return this.getTags().stream().filter(tag -> tag instanceof PubKeyTag).map(tag -> (PubKeyTag)tag).map(PubKeyTag::getPublicKey).toList();
    }

    @Override
    protected void validateKind() {
        if (this.getKind().intValue() != Kind.TEXT_NOTE.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.TEXT_NOTE.getValue()));
        }
    }

    @Generated
    public TextNoteEvent() {
    }
}

