/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.json.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.StreamSupport;
import nostr.base.IEvent;
import nostr.base.PublicKey;
import nostr.base.Signature;
import nostr.event.BaseTag;
import nostr.event.impl.CalendarEvent;

public class CalendarEventDeserializer
extends StdDeserializer<CalendarEvent> {
    public CalendarEventDeserializer() {
        super(CalendarEvent.class);
    }

    public CalendarEvent deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonNode calendarTimeBasedEventNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        ArrayNode tags = (ArrayNode)calendarTimeBasedEventNode.get("tags");
        List<BaseTag> baseTags = StreamSupport.stream(tags.spliterator(), false).toList().stream().map(JsonNode::elements).map(element -> (BaseTag)IEvent.MAPPER_BLACKBIRD.convertValue(element, BaseTag.class)).toList();
        HashMap generalMap = new HashMap();
        calendarTimeBasedEventNode.fields().forEachRemaining(generalTag -> generalMap.put((String)generalTag.getKey(), ((JsonNode)generalTag.getValue()).asText()));
        CalendarEvent calendarEvent = new CalendarEvent(new PublicKey((String)generalMap.get("pubkey")), baseTags, (String)generalMap.get("content"));
        calendarEvent.setId((String)generalMap.get("id"));
        calendarEvent.setCreatedAt(Long.valueOf((String)generalMap.get("created_at")));
        calendarEvent.setSignature(Signature.fromString((String)((String)generalMap.get("sig"))));
        return calendarEvent;
    }
}

