/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.tag;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.beans.Transient;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import nostr.base.ISignable;
import nostr.base.PublicKey;
import nostr.base.Signature;
import nostr.base.annotation.Key;
import nostr.base.annotation.Tag;
import nostr.event.BaseTag;

@Tag(code="delegation", nip=26)
@JsonPropertyOrder(value={"pubkey", "conditions", "signature"})
public class DelegationTag
extends BaseTag
implements ISignable {
    @Key
    @JsonProperty(value="delegator")
    private PublicKey delegator;
    @Key
    @JsonProperty(value="conditions")
    private String conditions;
    @Key
    @JsonProperty(value="token")
    private Signature signature;

    public DelegationTag(PublicKey delegator, String conditions) {
        this.delegator = delegator;
        this.conditions = conditions == null ? "" : conditions;
    }

    @Transient
    public String getToken() {
        return "nostr:" + this.getCode() + ":" + this.delegator.toString() + ":" + this.conditions;
    }

    public Consumer<Signature> getSignatureConsumer() {
        return this::setSignature;
    }

    public Supplier<ByteBuffer> getByteArraySupplier() {
        return () -> ByteBuffer.wrap(this.getToken().getBytes(StandardCharsets.UTF_8));
    }

    @Generated
    public PublicKey getDelegator() {
        return this.delegator;
    }

    @Generated
    public String getConditions() {
        return this.conditions;
    }

    @Generated
    public Signature getSignature() {
        return this.signature;
    }

    @JsonProperty(value="delegator")
    @Generated
    public void setDelegator(PublicKey delegator) {
        this.delegator = delegator;
    }

    @JsonProperty(value="conditions")
    @Generated
    public void setConditions(String conditions) {
        this.conditions = conditions;
    }

    @JsonProperty(value="token")
    @Generated
    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    @Override
    @Generated
    public String toString() {
        return "DelegationTag(delegator=" + String.valueOf(this.getDelegator()) + ", conditions=" + this.getConditions() + ", signature=" + String.valueOf(this.getSignature()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DelegationTag)) {
            return false;
        }
        DelegationTag other = (DelegationTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PublicKey this$delegator = this.getDelegator();
        PublicKey other$delegator = other.getDelegator();
        if (this$delegator == null ? other$delegator != null : !this$delegator.equals(other$delegator)) {
            return false;
        }
        String this$conditions = this.getConditions();
        String other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !this$conditions.equals(other$conditions)) {
            return false;
        }
        Signature this$signature = this.getSignature();
        Signature other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DelegationTag;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PublicKey $delegator = this.getDelegator();
        result = result * 59 + ($delegator == null ? 43 : $delegator.hashCode());
        String $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : $conditions.hashCode());
        Signature $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        return result;
    }

    @Generated
    public DelegationTag(PublicKey delegator, String conditions, Signature signature) {
        this.delegator = delegator;
        this.conditions = conditions;
        this.signature = signature;
    }

    @Generated
    public DelegationTag() {
    }
}

